package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author licancan
 * @description 商险结算表 t_insurance_settle
 * @date 2022-07-25 14:20:16
 */
@Data
@TableName("t_insurance_settle")
@Schema(description = "商险结算表")
public class TInsuranceSettle implements Serializable {
    /**
     * 主键
     */
	@Schema(description = "主键")
	@TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 商险明细id
     */
	@Schema(description = "商险明细id")
    private String insDetailId;

    /**
     * 结算状态
     */
	@Schema(description = "结算状态")
    private String settleHandleStatus;

    /**
     * 结算类型 (0、与薪资合并结算 1、单独结算)
     */
	@Schema(description = "结算类型 (0、与薪资合并结算 1、单独结算)")
    private Integer settleType;

    /**
     * 实际保费
     */
	@Schema(description = "实际保费")
    private BigDecimal actualPremium;

    /**
     * 预估保费
     */
	@Schema(description = "预估保费")
    private BigDecimal estimatePremium;

    /**
     * 创建时间
     */
	@Schema(description = "创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
	@Schema(description = "更新时间")
    private LocalDateTime updateTime;

    /**
     * 实际费用推送标识 1是 0否
     */
	@Schema(description = "实际费用推送标识 1是 0否")
    private Integer isActualPush;

    /**
     * 预估费用推送标识 1是 0否
     */
	@Schema(description = "预估费用推送标识 1是 0否")
    private Integer isEstimatePush;

    /**
     * 实际保费推送时间
     */
	@Schema(description = "实际保费推送时间")
    private LocalDateTime actualPushTime;

    /**
     * 预估保费推送时间
     */
	@Schema(description = "预估保费推送时间")
    private LocalDateTime estimatePushTime;

    /**
     * 结算完成时间
     */
	@Schema(description = "结算完成时间")
    private LocalDateTime settleDoneTime;

    private static final long serialVersionUID = 1L;

}