package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 险种表
 * @TableName t_insurance_type
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_insurance_type")
@Tag(name = "险种表")
public class TInsuranceType extends BaseEntity {
    /**
     * 险种id
     */
	@Schema(description = "险种id")
	@TableId(type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 险种名称
     */
	@NotBlank(message = "险种名称不能为空")
	@Schema(description = "险种名称")
    private String name;

    /**
     * 保险公司主键ID
     */
	@NotBlank(message = "所属保险公司不能为空")
	@Schema(description = "保险公司主键ID")
    private String insuranceCompanyId;

    /**
     * 收款单位名称
     */
	@NotBlank(message = "收款单位名称不能为空")
	@Schema(description = "收款单位名称")
    private String receiptUnitName;

    /**
     * 收款银行名称
     */
	@NotBlank(message = "收款银行名称不能为空")
	@Schema(description = "收款银行名称")
    private String bankName;

    /**
     * 收款银行账号
     */
	@NotBlank(message = "收款银行账号不能为空")
	@Schema(description = "收款银行账号")
    private String bankNo;

    /**
     * 删除标志(0：未删除，1：删除)
     */
	@Schema(description = "是否删除 0否/1是")
    private Integer deleteFlag;

}