package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 费率表
 * @TableName t_insurance_type_rate
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_insurance_type_rate")
@Tag(name = "费率表")
public class TInsuranceTypeRate extends BaseEntity {
    /**
     * 费率id
     */
	@Schema(description = "费率id")
	@TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 险种ID
     */
	@NotBlank(message = "所属险种不能为空")
	@Schema(description = "险种ID")
    private String insuranceTypeId;

    /**
     * 月数
     */
	@NotBlank(message = "月不能为空")
	@Schema(description = "月数")
    private String month;

    /**
     * 费率
     */
	@NotBlank(message = "费率不能为空")
	@Schema(description = "费率")
    private String rate;

	/**
	 * 删除标志(0：未删除，1：删除)
	 */
	@Schema(description = "是否删除 0否/1是")
	private Integer deleteFlag;



}