package com.yifu.cloud.plus.v1.yifu.insurances.util;

import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * @author licancan
 * @description 日期工具类
 * @date 2022-07-19 14:20:54
 */
public class LocalDateUtil {
	/**
	 * 年格式：yyyy
	 */
	public static final String NORM_YEAR_PATTERN = "yyyy";
	/**
	 * 年月格式：yyyy-MM
	 */
	public static final String NORM_MONTH_PATTERN = "yyyy-MM";
	/**
	 * 标准日期格式：yyyy-MM-dd
	 */
	public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
	/**
	 * 标准时间格式：HH:mm:ss
	 */
	public static final String NORM_TIME_PATTERN = "HH:mm:ss";
	/**
	 * 标准日期时间格式，精确到分：yyyy-MM-dd HH:mm
	 */
	public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
	/**
	 * 标准日期时间格式，精确到秒：yyyy-MM-dd HH:mm:ss
	 */
	public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

	/**
	 * 判断是否是日期
	 *
	 * @author licancan
	 * @param strDate
	 * @return {@link Boolean}
	 */
	public static Boolean isDate(String strDate,String pattern){
		if (Common.isEmpty(strDate)){
			return false;
		}
		try {
			DateFormat dateFormat = new SimpleDateFormat(pattern);
			Date date = dateFormat.parse(strDate);
			Calendar cal = Calendar.getInstance();
			cal.setTime(date);
			return true;
		}catch (ParseException pe){
			System.out.println("日期解析异常，返回false");
			return false;
		}
	}

	/**
	 * 字符串格式的日期转LocalDate
	 *
	 * @author licancan
	 * @param strDate
	 * @return {@link LocalDate}
	 */
	public static LocalDate parseLocalDate(String strDate){
		DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(NORM_DATE_PATTERN, Locale.CHINA);
		LocalDate localDate = LocalDate.parse(strDate, dateTimeFormatter);
		return localDate;
	}

	/**
	 * 判断时间是否是将来时间（大于当天）
	 *
	 * @author licancan
	 * @param strDate
	 * @return {@link boolean}
	 */
	public static boolean isFutureDate(String strDate){
		boolean flag = false;
		//在日期字符串非空时执行
		if (!Common.isEmpty(strDate)) {
			//今日的开始时间
			Date nowDate = new Date();
			Date pastDate = null;
			//格式化日期
			SimpleDateFormat sdf = new SimpleDateFormat(NORM_DATE_PATTERN, Locale.CHINA);
			try {
				//将字符串转为日期格式，如果此处字符串为非合法日期就会抛出异常。
				pastDate = sdf.parse(strDate);
				//调用Date里面的after方法来做判断
				flag = pastDate.after(nowDate);
				if (flag) {
					System.out.println("该日期晚于今日");
				}else {
					System.out.println("该日期早于今日");
				}
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}else {
			System.out.println("日期参数不可为空");
		}
		return flag;
	}

	/**
	 * 判断传入的月份是否大于等于本月（结算月份 >= 派单月份）
	 *
	 * @author licancan
	 * @param strMonth 传入的月份
	 * @return {@link boolean}
	 */
	public static boolean isCurrentOrFutureMonth(String strMonth){
		boolean flag = false;
		//在日期字符串非空时执行
		if (!Common.isEmpty(strMonth)) {
			SimpleDateFormat sdf = new SimpleDateFormat(NORM_MONTH_PATTERN, Locale.CHINA);
			try {
				//当前时间
				Calendar cal1 = Calendar.getInstance();
				//传入的字符串解析时间
				Calendar cal2 = Calendar.getInstance();
				Date parseDate = sdf.parse(strMonth);
				cal2.setTime(parseDate);
				if (cal1 == null || cal2 == null) {
					throw new IllegalArgumentException("The date must not be null");
				}
				if (cal2.get(Calendar.YEAR) > cal1.get(Calendar.YEAR)){
					flag = true;
				}else if(cal2.get(Calendar.YEAR) == cal1.get(Calendar.YEAR) && cal2.get(Calendar.MONTH) >= cal1.get(Calendar.MONTH)){
					flag = true;
				}
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}else {
			System.out.println("年月参数不可为空");
		}
		return flag;
	}

	//获取指定时间的指定格式
	public static String formatTime(LocalDate time, String pattern) {
		return time.format(DateTimeFormatter.ofPattern(pattern));
	}

	public static void main(String[] args) {
		System.out.println(isCurrentOrFutureMonth("2023-1"));
	}
}
