package com.yifu.cloud.plus.v1.yifu.insurances.util;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ValidityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;

import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ValidityUtil {

    /**
     * @param mobile
     * @Description: 验证工资、档案手机号码格式
     * @Author: hgw
     * @Date: 2021/8/31 10:48
     * @return: boolean
     **/
    public static boolean validateEmpPhone(String mobile) {
        if (Common.isEmpty(mobile)){
            return Boolean.FALSE;
        }
        return mobile.matches(ValidityConstants.EMP_PHONE_PATTERN);
    }

    /**
     * 验证手机号码，不符合规则返回true 反之 false
     * @author fxj
     * @param mobile
     * @return
     */
    public static boolean checkInvalidEmpPhone(String mobile) {
        return !validateEmpPhone(mobile);
    }
    /**
     * @Description: 验证手机号码格式
     * @param mobile 手机号码
     * @return boolean
     */
    public static boolean validateMobile(String mobile) {
        if (Common.isEmpty(mobile)){
            return Boolean.FALSE;
        }
        return mobile.matches(ValidityConstants.MOBILE_PATTERN);
    }

    /**
     * 验证是否是电信手机号,133、153、180、189、177
     * @param mobile 手机号
     * @return boolean
     */
    public static boolean validateTelecom(String mobile){
        if(Common.isEmpty(mobile)){
            return Boolean.FALSE ;
        }
        return mobile.matches(ValidityConstants.CHINA_TELECOM_PATTERN) ;
    }

    /**
     * 验证是否是联通手机号 130,131,132,155,156,185,186,145,176,1707,1708,1709,175
     * @param mobile 电话号码
     * @return boolean
     */
    public static boolean validateUnionMobile(String mobile){
        if(Common.isEmpty(mobile)){
            return Boolean.FALSE ;
        }
        return mobile.matches(ValidityConstants.CHINA_UNICOM_PATTERN) ;
    }

    /**
     * 验证是否是移动手机号
     * @param mobile 手机号 134,135,136,137,138,139,150,151,152,157,158,159,182,183,184,187,188,147,178,1705
     * @return boolean
     */
    public static boolean validateMoveMobile(String mobile){
        if(Common.isEmpty(mobile)){
            return Boolean.FALSE ;
        }
        return mobile.matches(ValidityConstants.CHINA_MOVE_PATTERN) ;
    }

    /**
     * @Description: 验证密码格式  6-16 位字母、数字
     * @param pwd 密码
     * @return boolean
     */
    public static boolean validatePwd(String pwd) {
        if (Common.isEmpty(pwd)){
            return Boolean.FALSE;
        }
        return Pattern.matches(ValidityConstants.PASSWORD_PATTERN, pwd);
    }

    /**
     * 验证座机号码，格式如：58654567,023-58654567
     * @param landline 固话、座机
     * @return boolean
     */
    public static boolean validateLandLine(final String landline) {
        if(Common.isEmpty(landline)){
            return Boolean.FALSE;
        }
        return landline.matches(ValidityConstants.LANDLINE_PATTERN);
    }

    /**
     * 验证邮政编码
     * @param postCode 邮政编码
     * @return boolean
     */
    public static boolean validatePostCode(final String postCode){
        if(Common.isEmpty(postCode)){
            return Boolean.FALSE ;
        }
        return postCode.matches(ValidityConstants.POSTCODE_PATTERN) ;
    }

    /**
     * 验证邮箱（电子邮件）
     * @param email 邮箱（电子邮件）
     * @return boolean
     */
    public static boolean validateEamil(final String email){
        if(Common.isEmpty(email)){
            return Boolean.FALSE ;
        }
        return email.matches(ValidityConstants.EMAIL_PATTERN) ;
    }

    /**
     * 判断年龄，1-120之间
     * @param age 年龄
     * @return boolean
     */
    public static boolean validateAge(final String age){
        if(Common.isEmpty(age)){
            return Boolean.FALSE ;
        }
        return age.matches(ValidityConstants.AGE_PATTERN) ;
    }

    /**
     * 身份证验证
     * @param idCard 身份证
     * @return boolean
     */
    public static boolean validateIDCard(final String idCard){
        if(Common.isEmpty(idCard)){
            return Boolean.FALSE ;
        }
        return idCard.matches(ValidityConstants.IDCARD_PATTERN) ;
    }

    /**
     * 姓名验证
     *
     * @author licancan
     * @param userName 姓名
     * @return {@link boolean}
     */
    public static boolean validateUserName(final String userName){
        if(Common.isEmpty(userName)){
            return Boolean.FALSE ;
        }
        return userName.matches(ValidityConstants.USER_NAME_PATTERN) ;
    }

    /**
     * URL地址验证
     * @param url URL地址
     * @return boolean
     */
    public static boolean validateUrl(final String url){
        if(Common.isEmpty(url)){
            return Boolean.FALSE ;
        }
        return url.matches(ValidityConstants.URL_PATTERN) ;
    }

    /**
     * 验证QQ号
     * @param qq QQ号
     * @return boolean
     */
    public static boolean validateQq(final String qq){
        if(Common.isEmpty(qq)){
            return Boolean.FALSE ;
        }
        return qq.matches(ValidityConstants.QQ_PATTERN) ;
    }

    /**
     * 验证字符串是否全是汉字
     * @param str 字符串
     * @return boolean
     */
    public static boolean validateChinese(final String str){
        if(Common.isEmpty(str)){
            return Boolean.FALSE ;
        }
        return str.matches(ValidityConstants.CHINESE_PATTERN) ;
    }
    /**
     * 验证字符串是否全是汉字 最多20位
     *
     * @author licancan
     * @param str
     * @return {@link boolean}
     */
    public static boolean validateChinese20(final String str){
        if(Common.isEmpty(str)){
            return Boolean.FALSE;
        }
        return str.matches(ValidityConstants.CHINESE_PATTERN_20) ;
    }

    /**
     * 校验用户姓名是否是初始化的值
     *
     * @author licancan
     * @param str 姓名
     * @param phone 手机号
     * @return {@link boolean}
     */
    public static boolean validateIsInitialize(final String str,final String phone){
        if(Common.isEmpty(str)){
            return Boolean.FALSE;
        }
        //校验手机号是否正确
        if (!validateMobile(phone)){
            return Boolean.FALSE;
        }
        String initializeInfo = "用户".concat(phone.substring(phone.length()-6, phone.length()));
        if (!str.trim().equals(initializeInfo)){
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /**
     * 判断字符串是否全字母
     * @param str 字符串
     * @return boolean
     */
    public static boolean validateStrEnglish(final String str){
        if(Common.isEmpty(str)){
            return Boolean.FALSE ;
        }
        return str.matches(ValidityConstants.STR_ENG_PATTERN) ;
    }

    /**
     * 判断是否是整数，包括负数
     * @param str 字符串
     * @return boolean
     */
    public static boolean validateInteger(final String str){
        if(Common.isEmpty(str)){
            return Boolean.FALSE ;
        }
        return str.matches(ValidityConstants.INTEGER_PATTERN) ;
    }

    /**
     * 判断是否是大于0的正整数
     * @param str 字符串
     * @return boolean
     */
    public static boolean validatePositiveInt(final String str){
        if(Common.isEmpty(str)){
            return Boolean.FALSE ;
        }
        return str.matches(ValidityConstants.POSITIVE_INTEGER_PATTERN) ;
    }

    public static boolean isFloat(String numStr) {
        if(numStr==null){
            return false;
        }

        if(numStr==""){
            return false;
        }
        //验证是否是float型
        if(numStr.contains(".")){
            if(numStr.indexOf('.')==numStr.lastIndexOf('.')){
                StringTokenizer st=new StringTokenizer(numStr,".");
                while(st.hasMoreElements()){
                    String splitStr= st.nextToken();
                    for(int i=splitStr.length();--i>=0;){
                        if(!Character.isDigit(splitStr.charAt(i))){
                            return false;
                        }
                    }
                }
            }
        }else{
            return false;
        }
        return true;
    }
	public static boolean isMonth(String month){
		for(String s : CommonConstants.MonthStrArray){
			if (s.equals(month)){
				return true;
			}
		}
		return false;
	}


    public static boolean isInt(String numStr) {
        if(numStr==null){
            return false;
        }

        if(numStr==""){
            return false;
        }
        //验证是否是float型
        if(numStr.contains(".")){
            return false;
        }else{
            //验证是否是int型
            for(int i=numStr.length();--i>=0;){
                if(!Character.isDigit(numStr.charAt(i))){
                    return false;
                }
            }
        }
        return true;
    }
}
