package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaji
 * @description 变更所属项目
 * @date 2022-07-21 15:35:49
 */
@Data
@Tag(name = "变更所属项目")
public class DeptChangeCheckParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;
	//姓名+身份证号+原项目编码+保险公司+险种+保单开始时间+保单结束时间+保单结束时间+标准+有效+未减员 是否存在校验
	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证号码
	 */
	@Schema(description = "员工身份证号码")
	private String empIdCardNo;

	/**
	 * 原项目编码
	 */
	@Schema(description = "原项目编码")
	private String oldDeptNo;

	/**
	 * 新项目编码
	 */
	@Schema(description = "新项目编码")
	private String newDeptNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始日期
	 */
	@Schema(description = "保单开始日期")
	private String policyStart;

	/**
	 * 保单结束日期
	 */
	@Schema(description = "保单结束日期")
	private String policyEnd;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

	/**
	 * 结算方式
	 */
	@Schema(description = "结算方式")
	private Integer settleType;

}
