package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author licancan
 * @description 投保列表请求参数
 * @date 2022-07-20 16:14:19
 */
@Data
@Schema(description = "投保列表请求参数")
public class InsuranceListParam implements Serializable {
	private static final long serialVersionUID = -4692341622141432288L;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 投保状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@Schema(description = "投保状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	private Integer buyHandleStatus;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
}
