package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author licancan
 * @description 投保列表VO
 * @date 2022-07-20 16:18:41
 */
@Data
@Schema(description = "投保列表VO")
public class InsuranceListVO implements Serializable {
	private static final long serialVersionUID = -6673220061558171816L;

	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 投保类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 投保类型， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String projectName;

	/**
	 * 项目编码
	 */
	@JsonIgnore
	private String deptNo;

	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	private String post;

	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 创建人姓名
	 */
	@Schema(description = "创建人(派单人)")
	private String createName;

	/**
	 * 投保状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@Schema(description = "投保状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	private Integer buyHandleStatus;

	/**
	 * 结算类型 (0、预估 1、实缴)
	 */
	@Schema(description = "结算类型 (0、预估 1、实缴)")
	private Integer settleType;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;
}
