package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaji
 * @description 减员校验类
 * @date 2022-07-19 09:09:41
 */
@Data
@Tag(name = "减员校验类")
public class InsuranceRefundCheck implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证号码
	 */
	@Schema(description = "员工身份证号码")
	private String empIdCardNo;
	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;
	/**
	 * 保单开始日期
	 */
	@Schema(description = "保单开始日期")
	private String policyStart;
	/**
	 * 保单结束日期
	 */
	@Schema(description = "保单结束日期")
	private String policyEnd;

	/**
	 * 退款金额
	 */
	@Schema(description = "退款金额")
	private String refundMoney;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

}
