package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaji
 * @description 减员办理查询条件
 * @date 2022-07-21 11:40:47
 */
@Data
@Tag(name = "减员办理查询条件")
public class InsuranceRefundHandlingParam implements Serializable {

	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 减员状态 1待减员 2减员中 3减员退回 4减员成功
	 */
	@Schema(description = "减员状态 1待减员 2减员中 3减员退回 4减员成功")
	private Integer reduceHandleStatus;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 保险公司id
	 */
	@Schema(description = "保险公司id")
	private String insuranceCompanyId;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 是否出险 0未出险 1已出险
	 */
	@Schema(description = "是否出险 0未出险 1已出险")
	private Integer isUse;

	/**
	 * 是否有效 0有效 1无效
	 */
	@Schema(description = "是否有效 0有效 1无效")
	private Integer isEffect;

	/**
	 * 是否过期 0未过期 1已过期
	 */
	@Schema(description = "是否过期 0未过期 1已过期")
	private Integer isOverdue;


}
