package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhaji
 * @description 减员办理类
 * @date 2022-07-21 11:56:40
 */
@Data
@Tag(name = "减员办理类")
public class InsuranceRefundListParam implements Serializable {

	private static final long serialVersionUID = -2689686777914935788L;

	@Schema(name = "减员办理类型")
	@NotBlank(message = "减员办理类型不能为空")
	private Integer refundType;

	@Schema(description = "减员办理列表")
	private List<String> insuranceDetailList;

	@Schema(name = "更新人")
	private String updateBy;

	@Schema(name = "更新时间")
	private LocalDateTime updateTime;

}
