package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author zhaji
 * @description 已减员列表
 * @date 2022-07-21 11:31:30
 */
@Data
@Tag(name = "已减员列表")
public class InsuranceRefundListVo implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String projectName;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 投保类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 投保类型， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	private String post;

	/**
	 * 商险购买地省code
	 */
	@Schema(description = "商险购买地省code")
	private Integer insuranceProvince;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
	private String insuranceProvinceName;

	/**
	 * 商险购买地市code
	 */
	@Schema(description = "商险购买地市code")
	private Integer insuranceCity;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
	private String insuranceCityName;

	/**
	 * 商险办理省code
	 */
	@Schema(description = "商险办理省code")
	private Integer insuranceHandleProvince;

	/**
	 * 商险办理省
	 */
	@Schema(description = "商险办理省")
	private String insuranceHandleProvinceName;

	/**
	 * 商险办理城市code
	 */
	@Schema(description = "商险办理城市code")
	private Integer insuranceHandleCity;

	/**
	 * 商险办理城市
	 */
	@Schema(description = "商险办理城市")
	private String insuranceHandleCityName;

	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	private String dieDisableQuota;

	/**
	 * 减员派单日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "减员派单日期")
	private LocalDate refundCreateTime;


}
