package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author zhaji
 * @description 减员办理参数
 * @date 2022-07-25 14:17:16
 */
@Data
@Schema(name = "减员办理参数")
public class InsuranceRefundOperationParam implements Serializable {

	private static final long serialVersionUID = -2689686777914935788L;

	@Schema(name = "办理类型")
	@NotBlank(message = "办理类型不能为空")
	private Integer operationType;

	@Schema(name = "减员办理列表")
	private List<InsuranceRefundHandlingListVo>  insuranceRefundHandlingList;

	@Schema(name = "办理参数")
	private InsuranceRefundHandlingParam param;

}
