package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author licancan
 * @description 登记保单保费入参
 * @date 2022-07-21 17:03:31
 */
@Data
@Schema(description = "登记保单保费入参")
public class InsuranceRegisterParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 保单编号
	 */
	@Schema(description = "保单编号")
	private String policyNo;

	/**
	 * 实际保费
	 */
	@Schema(description = "实际保费")
	private String actualPremium;

	/**
	 * 发票号
	 */
	@Schema(description = "发票号")
	private String invoiceNo;


	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;
}
