package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author licancan
 * @description 商险办理替换入参
 * @date 2022-07-20 08:43:31
 */
@Data
@Schema(description = "商险办理替换入参")
public class InsuranceReplaceParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 替换员工姓名
	 */
	@Schema(description = "替换员工姓名")
	private String replaceEmpName;

	/**
	 * 替换员工身份证号
	 */
	@Schema(description = "替换员工身份证号")
	private String replaceEmpIdcardNo;

	/**
	 * 替换员工项目编码
	 */
	@Schema(description = "替换员工项目编码")
	private String replaceDeptNo;

	/**
	 * 岗位
	 */
	@Schema(description = "岗位")
	private String post;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

}
