package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceCompanyService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zhaji
 * @description 保险公司相关
 * @date 2022-07-18 17:40:50
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceCompany")
@Tag(name = "保险公司相关")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TInsuranceCompanyController {

	@Resource
	private TInsuranceCompanyService insuranceCompanyService;

	/**
	 * 保险公司分页查询
	 * @param page 分页对象
	 * @param insuranceCompany 保险公司
	 * @return
	 */
	@Operation(summary = "保险公司分页查询", description = "保险公司分页查询")
	@GetMapping("/page" )
	public R<IPage<TInsuranceCompany>> getInsuranceCompanyPage(Page page, TInsuranceCompany insuranceCompany) {
		return R.ok(insuranceCompanyService.pageDiy(page, insuranceCompany));
	}

	/**
	 * 通过id查询保险公司详情
	 * @param id id
	 * @return R
	 */
	@GetMapping("/{id}" )
	@Operation(summary = "通过id查询保险公司详情", description = "通过id查询保险公司详情")
	public R<TInsuranceCompany> getById(@PathVariable("id" ) String id) {
		return R.ok(insuranceCompanyService.getById(id));
	}


	/**
	 * 新增保险公司
	 * @param insuranceCompany 保险公司明细
	 * @return R
	 */
	@Operation(summary = "新增保险公司", description = "新增保险公司：hasPermission('demo_insuranceCompany_add')")
	@SysLog("新增保险公司" )
	@PostMapping("/save")
	//@PreAuthorize("@pms.hasPermission('demo_insuranceCompany_add')" )
	public R save(@RequestBody TInsuranceCompany insuranceCompany) {
		return insuranceCompanyService.saveInsuranceCompany(insuranceCompany);
	}

	/**
	 * 修改保险公司
	 * @param insuranceCompany 修改实体类
	 * @return R
	 */
	@Operation(summary = "修改保险公司", description = "修改保险公司：hasPermission('demo_insuranceCompany_update')")
	@SysLog("修改保险公司" )
	@PostMapping("/update")
	//@PreAuthorize("@pms.hasPermission('demo_insuranceCompany_update')" )
	public R update(@RequestBody TInsuranceCompany insuranceCompany) {
		return insuranceCompanyService.updateInsuranceCompany(insuranceCompany);
	}

	/**
	 * 查询保险公司列表（不分页）
	 * @return
	 */
	@Operation(summary = "查询保险公司列表（不分页）", description = "查询保险公司列表（不分页）")
	@GetMapping("/list" )
	public R<List<TInsuranceCompany>> getInsuranceCompanyList() {
		return R.ok(insuranceCompanyService.getInsuranceCompanyList());
	}




}
