package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceDetailService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_insurance_detail(商险明细表)】的数据库操作controller
 * @date 2022-07-18 16:38:48
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceDetail")
@Tag(name = "商险相关")
@Validated
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TInsuranceDetailController {
	@Resource
	private TInsuranceDetailService tInsuranceDetailService;

	/***********************商险办理********************************/
	/**
	 * 投保办理分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link R<IPage<InsuranceListVO>>}
	 */
	@Operation(summary = "投保办理分页查询", description = "投保办理分页查询")
	@PostMapping("/getInsuranceListPage")
	public R<IPage<InsuranceListVO>> getInsuranceListPage(Page<InsuranceListVO> page, @RequestBody InsuranceListParam param) {
		return R.ok(tInsuranceDetailService.getInsuranceListPage(page, param));
	}

	/**
	 * 投保办理不分页查询
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<InsuranceListVO>>}
	 */
	@Operation(summary = "投保办理不分页查询", description = "投保办理不分页查询")
	@PostMapping("/getInsuranceList")
	public R<List<InsuranceListVO>> getInsuranceList(@RequestBody InsuranceListParam param) {
		return R.ok(tInsuranceDetailService.getInsuranceList(param));
	}

	/**
	 * 商险新增
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceAddParam>>}
	 */
	@Operation(summary = "投保新增", description = "投保新增")
	@PostMapping("/addInsurance")
	public R<List<InsuranceAddParam>> addInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceAddParam> paramList){
		return tInsuranceDetailService.addInsurance(paramList);
	}

	/**
	 * 商险批增
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceBatchParam>>}
	 */
	@Operation(summary = "投保批增", description = "投保批增")
	@PostMapping("/batchInsurance")
	public R<List<InsuranceBatchParam>> batchInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceBatchParam> paramList){
		return tInsuranceDetailService.batchInsurance(paramList);
	}

	/**
	 * 商险替换
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceReplaceParam>>}
	 */
	@Operation(summary = "投保替换", description = "投保替换")
	@PostMapping("/replaceInsurance")
	public R<List<InsuranceReplaceParam>> replaceInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceReplaceParam> paramList){
		return tInsuranceDetailService.replaceInsurance(paramList);
	}

	/**
	 * 通过id删除
	 * 
	 * @author licancan
	 * @param id
	 * @return {@link R<String>}
	 */
	@GetMapping("/deleteInsurance")
	@Operation(summary = "通过id删除", description = "通过id删除")
	//@PreAuthorize("@pms.hasPermission('insurance_del')")
	public R<String> deleteInsurance(@RequestParam String id) {
		return tInsuranceDetailService.deleteInsurance(id);
	}

	/**
	 * 编辑
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<String>}
	 */
	@PostMapping("/editInsurance")
	@Operation(summary = "编辑", description = "编辑")
	//@PreAuthorize("@pms.hasPermission('insurance_edit')")
	public R<String> editInsurance(@RequestBody @Valid InsuranceEditParam param) {
		return tInsuranceDetailService.editInsurance(param);
	}

	/**
	 * 通过id查询
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R<InsuranceDetailVO>}
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<InsuranceDetailVO> getInsuranceDetailById(@PathVariable("id") String id) {
		return R.ok(tInsuranceDetailService.getInsuranceDetailById(id));
	}

	/**
	 * 导出办理
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<InsuranceExportListVO>>}
	 */
	@Operation(summary = "导出办理", description = "导出办理")
	@PostMapping("/getInsuranceExportList")
	public R<List<InsuranceExportListVO>> getInsuranceExportList(@RequestBody InsuranceExportListParam param) {
		return R.ok(tInsuranceDetailService.getInsuranceExportList(param));
	}

	/**
	 * 投保退回
	 *
	 * @author licancan
	 * @param idList
	 * @return {@link R<List<TInsuranceDetail>>}
	 */
	@Operation(summary = "投保退回", description = "投保退回")
	@PostMapping("/rollBackInsurance")
	public R<List<TInsuranceDetail>> rollBackInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<String> idList){
		return tInsuranceDetailService.rollBackInsurance(idList);
	}

	/**
	 * 办理成功
	 *
	 * @author licancan
	 * @param idList
	 * @return {@link R<List<TInsuranceDetail>>}
	 */
	@Operation(summary = "办理成功", description = "办理成功")
	@PostMapping("/successfulInsurance")
	public R<List<TInsuranceDetail>> successfulInsurance(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<String> idList){
		return tInsuranceDetailService.successfulInsurance(idList);
	}

	/**
	 * 登记保单保费
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceRegisterParam>>}
	 */
	@Operation(summary = "登记保单保费", description = "登记保单保费")
	@PostMapping("/registeredPolicyPremium")
	public R<List<InsuranceRegisterParam>> registeredPolicyPremium(@RequestBody @Valid @Size(min = 1,message = "集合不能为空") List<InsuranceRegisterParam> paramList){
		return tInsuranceDetailService.registeredPolicyPremium(paramList);
	}
	/***********************减员办理********************************/
	/**
	 * 导入减员校验
	 * @param insuranceRefundCheckList 导入减员校验
	 * @author zhaji
	 * @date 2022-07-19
	 * @since v1.0
	 */
	@PostMapping("/checkInsuranceRefundList")
	public R checkInsuranceRefundList(@RequestBody List<InsuranceRefundCheck> insuranceRefundCheckList){
		return tInsuranceDetailService.checkInsuranceRefundList(insuranceRefundCheckList);
	}

	/**
	 * 变更结算月
	 * @param settleMonthCheckList 变更结算月
	 * @author zhaji
	 * @date 2022-07-21
	 * @since v1.0
	 */
	@PostMapping("/settleMonthChange")
	@Operation(summary = "变更结算月", description = "变更结算月")
	public R settleMonthChange(@RequestBody List<SettleMonthChangeCheckParam> settleMonthCheckList){
		return tInsuranceDetailService.settleMonthChange(settleMonthCheckList);
	}

	/**
	 * 变更所属项目
	 * @param deptChangeCheckList 变更所属项目
	 * @author zhaji
	 * @date 2022-07-21
	 * @since v1.0
	 */
	@PostMapping("/deptChange")
	@Operation(summary = "变更所属项目", description = "变更所属项目")
	public R deptChange(@RequestBody List<DeptChangeCheckParam> deptChangeCheckList){
		return tInsuranceDetailService.deptChange(deptChangeCheckList);
	}

	/**
	 * 已投保列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询条件
	 * @return {@link R<IPage<InsuredListVo>>}
	 */
	@Operation(summary = "已投保列表分页查询", description = "已投保列表分页查询")
	@PostMapping("/getInsuredListPage")
	public R<IPage<InsuredListVo>> getInsuredListPage(Page<InsuredListVo> page, @RequestBody InsuredParam param) {
		return R.ok(tInsuranceDetailService.getInsuredListPage(page,param));
	}

	/**
	 * 已投保列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<List<InsuredListVo>>}
	 */
	@Operation(summary = "已投保列表不分页查询", description = "已投保列表不分页查询")
	@PostMapping("/getInsuredList")
	public R<List<InsuredListVo>> getInsuredList(@RequestBody InsuredParam param) {
		return R.ok(tInsuranceDetailService.getInsuredList(param),"查询成功");
	}

	/**
	 * 已减员列表分页查询
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<IPage< InsuranceRefundListVo >>}
	 */
	@Operation(summary = "已减员列表分页查询", description = "已减员列表分页查询")
	@PostMapping("/getInsuranceRefundPageList")
	public R<IPage<InsuranceRefundListVo>> getInsuranceRefundPageList(Page<InsuranceRefundParam> page, @RequestBody InsuranceRefundParam param) {
		return R.ok(tInsuranceDetailService.getInsuranceRefundPageList(page,param));
	}

	/**
	 * 已减员列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<List< InsuranceRefundListVo >>}
	 */
	@Operation(summary = "已减员列表不分页查询", description = "已减员列表不分页查询")
	@PostMapping("/getInsuranceRefundList")
	public R<List<InsuranceRefundListVo>> getInsuranceRefundList(@RequestBody InsuranceRefundParam param) {
		return R.ok(tInsuranceDetailService.getInsuranceRefundList(param));
	}


	/**
	 * 减员办理列表分页查询
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<IPage< InsuranceRefundHandlingListVo >>}
	 */
	@Operation(summary = "减员办理列表分页查询", description = "减员办理列表分页查询")
	@PostMapping("/getInsuranceRefundHandlingPageList")
	public R<IPage<InsuranceRefundHandlingListVo>> getInsuranceRefundHandlingPageList(Page<InsuranceRefundHandlingParam> page, @RequestBody InsuranceRefundHandlingParam param) {
		return R.ok(tInsuranceDetailService.getInsuranceRefundHandlingPageList(page,param));
	}

	/**
	 * 导出减员列表
	 *
	 * @author zhaji
	 * @param param 查询条件
	 * @return {@link R<List< InsuranceRefundHandlingListVo >>}
	 */
	@Operation(summary = "导出减员列表", description = "导出减员列表")
	@PostMapping("/getInsuranceRefundHandlingList")
	public R<List<InsuranceRefundHandlingListVo>> getInsuranceRefundHandlingList(@RequestBody InsuranceRefundOperationParam param) {
		return R.ok(tInsuranceDetailService.getInsuranceRefundHandlingList(param));
	}

	/**
	 * 减员办理
	 *
	 * @author zhaji
	 * @param insuranceDetail 减员信息
	 * @return {@link R<List< InsuranceRefundHandlingListVo >>}
	 */
	@Operation(summary = "减员办理", description = "减员办理")
	@PostMapping("/updateInsuranceRefund")
	public R updateInsuranceRefund(@RequestBody InsuranceRefundListParam insuranceDetail) {
		return tInsuranceDetailService.updateInsuranceRefund(insuranceDetail);
	}

	/**
	 * 根据保险公司名称查询保单明细
	 *
	 * @author zhaji
	 * @param CompanyName 保险公司id
	 * @return {@link R<List< InsuranceRefundHandlingListVo >>}
	 */
	@Operation(summary = "根据保险公司名称查询保单明细", description = "根据保险公司名称查询保单明细")
	@GetMapping("/selectByCompanyName")
	public R selectByCompanyName(String CompanyName) {
		return tInsuranceDetailService.selectByCompanyName(CompanyName);
	}

	/**
	 * 根据险种名称查询保单明细
	 *
	 * @author zhaji
	 * @param id 险种id
	 * @return {@link R<List< InsuranceRefundHandlingListVo >>}
	 */
	@Operation(summary = "根据险种名称查询保单明细", description = "根据险种名称查询保单明细")
	@GetMapping("/selectByTypeId")
	public R selectByTypeName(String id) {
		return tInsuranceDetailService.selectByTypeId(id);
	}


	/**
	 * 出险
	 *
	 * @author zhaji
	 * @param id 险种id
	 * @return {@link R<List< InsuranceRefundHandlingListVo >>}
	 */
	@Operation(summary = "出险", description = "出险")
	@GetMapping("/updateIsUse")
	public R updateIsUse(String id) {
		return tInsuranceDetailService.updateIsUse(id);
	}

}
