package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceTypeService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceTypeVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zhaji
 * @description 险种相关
 * @date 2022-07-18 17:41:08
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceType")
@Tag(name = "险种相关")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TInsuranceTypeController {
	@Resource
	private TInsuranceTypeService insuranceTypeService;

	/**
	 * 分页查询
	 * @param page 分页对象
	 * @param insuranceType 险种
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page" )
	public R<IPage<InsuranceTypeVo>> getInsuranceTypePage(Page page,TInsuranceType insuranceType) {
		return R.ok(insuranceTypeService.pageDiy(page, insuranceType));
	}

	/**
	 * 新增险种
	 * @param insuranceType 险种明细
	 * @return R
	 */
	@Operation(summary = "新增险种", description = "新增险种：hasPermission('demo_insuranceType_add')")
	@SysLog("新增险种")
	@PostMapping("/save")
	//@PreAuthorize("@pms.hasPermission('demo_insuranceType_add')" )
	public R save(@RequestBody TInsuranceType insuranceType) {
		return insuranceTypeService.saveInsuranceType(insuranceType);
	}

	/**
	 * 通过id查询险种详情
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询险种详情", description = "通过id查询：hasPermission('demo_insuranceType_get')")
	@GetMapping("/{id}" )
	//@PreAuthorize("@pms.hasPermission('demo_insuranceType_get')" )
	public R getInsuranceTypeDetail(@PathVariable("id" ) String id) {
		return insuranceTypeService.getInsuranceTypeDetail(id);
	}


	/**
	 * 修改险种
	 * @param insuranceType 险种明细
	 * @return R
	 */
	@Operation(summary = "修改险种", description = "新增险种：hasPermission('demo_insuranceType_add')")
	@SysLog("修改险种")
	@PostMapping("/update")
	//@PreAuthorize("@pms.hasPermission('demo_insuranceType_add')" )
	public R update(@RequestBody TInsuranceType insuranceType) {
		return insuranceTypeService.updateInsuranceType(insuranceType);
	}

	/**
	 * 查询险种列表
	 * @param insuranceType 险种信息
	 * @return
	 */
	@Operation(summary = "查询险种列表", description = "查询险种列表")
	@GetMapping("/list" )
	public R getInsuranceTypeList(TInsuranceType insuranceType) {
		return insuranceTypeService.getInsuranceTypeList(insuranceType);
	}
}
