package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeRate;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceTypeRateService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zhaji
 * @description 费率相关
 * @date 2022-07-18 17:41:20
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceTypeRate")
@Tag(name = "费率相关")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TInsuranceTypeRateController {

	@Resource
	private TInsuranceTypeRateService insuranceTypeRateService;

	/**
	 * 查询费率列表（不分页）
	 * @return
	 */
	@Operation(summary = "费率列表", description = "费率列表")
	@GetMapping("/list" )
	public R getInsuranceTypeRateList(String id) {
		return insuranceTypeRateService.getInsuranceTypeRateList(id);
	}

	/**
	 * 删除购买费率信息
	 * @param id 费率id
	 * @return R
	 */
	@Operation(summary = "删除购买费率信息", description = "删除购买费率信息：hasPermission('demo_insuranceTypeRate_delete')")
	@DeleteMapping("/{id}" )
	//@PreAuthorize("@pms.hasPermission('demo_insuranceTypeRate_delete')" )
	public R deleteById(@PathVariable("id" ) String id) {
		return insuranceTypeRateService.deleteInsuranceTypeRate(id);
	}

	/**
	 * 新增费率
	 * @param insuranceTypeRate 费率明细
	 * @return R
	 */
	@Operation(summary = "新增费率", description = "新增费率：hasPermission('demo_insuranceTypeRate_add')")
	@SysLog("新增费率" )
	@PostMapping("/save")
	//@PreAuthorize("@pms.hasPermission('demo_insuranceTypeRate_add')" )
	public R save(@RequestBody TInsuranceTypeRate insuranceTypeRate) {
		return insuranceTypeRateService.saveInsuranceTypeRate(insuranceTypeRate);
	}

}
