package com.yifu.cloud.plus.v1.yifu.insurances.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_insurance_detail(商险明细表)】的数据库操作Mapper
 * @date 2022-07-18 16:20:16
 */
@Mapper
public interface TInsuranceDetailMapper extends BaseMapper<TInsuranceDetail> {
	/***********************商险办理********************************/
	/**
	 * 投保办理分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link IPage< InsuranceListVO>}
	 */
	IPage<InsuranceListVO> getInsuranceListPage(Page<InsuranceListVO> page, @Param("param") InsuranceListParam param);

	/**
	 * 投保办理不分页查询
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List<InsuranceListVO>}
	 */
    List<InsuranceListVO> getInsuranceList(@Param("param") InsuranceListParam param);

	/**
	 * 通过id查询
	 *
	 * @author licancan
	 * @param id
	 * @return {@link InsuranceDetailVO}
	 */
	InsuranceDetailVO getInsuranceDetailById(@Param("id") String id);

	/**
	 * 导出办理勾选查询结果
	 *
	 * @author licancan
	 * @param idList
	 * @return {@link List<InsuranceExportListVO>}
	 */
	List<InsuranceExportListVO> getInsuranceExportListBySelect(@Param("idList") List<String> idList);

	/**
	 * 导出办理非勾选查询结果
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List< InsuranceExportListVO>}
	 */
	List<InsuranceExportListVO> getInsuranceExportList(@Param("param") InsuranceExportListParam param);

	/***********************减员办理********************************/

	/**
	 * 已投保列表分页查询
	 *
	 * @author zhaji
	 * @param page
	 * @param param
	 * @return {@link IPage< InsuredListVo>}
	 */
	IPage<InsuredListVo> getInsuredListPage(Page<InsuredListVo> page, @Param("param") InsuredParam param);

	/**
	 * 已投保列表不分页查询
	 *
	 * @author zhaji
	 * @param param
	 * @return {@link List<InsuredListVo>}
	 */
	List<InsuredListVo> getInsuredList(@Param("param") InsuredParam param);

	/**
	 * 已减员列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link IPage< InsuranceRefundListVo>}
	 */
	IPage<InsuranceRefundListVo> getInsuranceRefundPageList(Page<InsuranceRefundParam> page,  @Param("param")InsuranceRefundParam param);

	/**
	 * 已减员列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @return {@link List< InsuranceRefundListVo>}
	 */
	List<InsuranceRefundListVo> getInsuranceRefundList( @Param("param") InsuranceRefundParam param);

	/**
	 * 减员办理列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link IPage< InsuranceRefundHandlingListVo>}
	 */
	IPage<InsuranceRefundHandlingListVo> getInsuranceRefundHandlingPageList(Page<InsuranceRefundHandlingParam> page, @Param("param") InsuranceRefundHandlingParam param);

	/**
	 * 减员办理列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @return {@link List< InsuranceRefundHandlingListVo>}
	 */
	List<InsuranceRefundHandlingListVo> getInsuranceRefundHandlingList(@Param("param")InsuranceRefundHandlingParam param);

	/**
	 * 减员办理
	 *
	 * @author zhaji
	 * @param insuranceDetail
	 * @return {@link boolean}
	 */
	Integer updateInsuranceRefund(@Param("param") InsuranceRefundListParam insuranceDetail);

	/**
	 * 查询保单列表
	 *
	 * @author zhaji
	 * @param idList idList
	 * @return {@link List< TInsuranceDetail>}
	 */
	List<TInsuranceDetail> selectDetailListByIds(@Param("idList") String [] idList);
}
