package com.yifu.cloud.plus.v1.yifu.insurances.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;

import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_insurance_detail(商险明细表)】的数据库操作Service
 * @date 2022-07-18 16:20:16
 */
public interface TInsuranceDetailService extends IService<TInsuranceDetail> {

	/***********************商险办理********************************/
	/**
	 * 投保办理分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link IPage<InsuranceListVO>}
	 */
	IPage<InsuranceListVO> getInsuranceListPage(Page<InsuranceListVO> page, InsuranceListParam param);

	/**
	 * 投保办理不分页查询
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List<InsuranceListVO>}
	 */
	List<InsuranceListVO> getInsuranceList(InsuranceListParam param);

	/**
	 * 商险新增
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceAddParam>>}
	 */
	R<List<InsuranceAddParam>> addInsurance(List<InsuranceAddParam> paramList);

	/**
	 * 商险批增
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceBatchParam>>}
	 */
	R<List<InsuranceBatchParam>> batchInsurance(List<InsuranceBatchParam> paramList);
	/**
	 * 商险替换
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceReplaceParam>>}
	 */
	R<List<InsuranceReplaceParam>> replaceInsurance(List<InsuranceReplaceParam> paramList);

	/**
	 * 通过id删除
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R<String>}
	 */
	R<String> deleteInsurance(String id);

	/**
	 * 编辑
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<String>}
	 */
	R<String> editInsurance(InsuranceEditParam param);

	/**
	 * 通过id查询
	 *
	 * @author licancan
	 * @param id
	 * @return {@link InsuranceDetailVO}
	 */
	InsuranceDetailVO getInsuranceDetailById(String id);

	/**
	 * 导出办理
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List<InsuranceExportListVO>}
	 */
	List<InsuranceExportListVO> getInsuranceExportList(InsuranceExportListParam param);

	/**
	 * 投保退回
	 *
	 * @author licancan
	 * @param idList
	 * @return {@link R<List<TInsuranceDetail>>}
	 */
	R<List<TInsuranceDetail>> rollBackInsurance(List<String> idList);

	/**
	 * 办理成功
	 *
	 * @author licancan
	 * @param idList
	 * @return {@link R<List<TInsuranceDetail>>}
	 */
	R<List<TInsuranceDetail>> successfulInsurance(List<String> idList);

	/**
	 * 登记保单保费
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceRegisterParam>>}
	 */
	R<List<InsuranceRegisterParam>> registeredPolicyPremium(List<InsuranceRegisterParam> paramList);

	/***********************减员办理********************************/

	/**
	 * 减员导入校验
	 *
	 * @author zhaji
	 * @param insuranceRefundCheckList 减员表
	 * @return {@link R}
	 */
	R checkInsuranceRefundList(List<InsuranceRefundCheck> insuranceRefundCheckList);

	/**
	 * 已投保列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link IPage< InsuredListVo>}
	 */
	IPage<InsuredListVo> getInsuredListPage(Page<InsuredListVo> page, InsuredParam param);

	/**
	 * 已投保列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @return {@link List< InsuredListVo>}
	 */
	List<InsuredListVo> getInsuredList(InsuredParam param);

	/**
	 * 已减员列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页数据
	 * @param param 查询参数
	 * @return {@link IPage<  InsuranceRefundListVo >}
	 */
	IPage<InsuranceRefundListVo>  getInsuranceRefundPageList(Page<InsuranceRefundParam> page, InsuranceRefundParam param);

	/**
	 * 已减员列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @return {@link List<  InsuranceRefundListVo >}
	 */
	List<InsuranceRefundListVo> getInsuranceRefundList(InsuranceRefundParam param);

	/**
	 * 减员办理列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页数据
	 * @param param 查询参数
	 * @return {@link IPage< InsuranceRefundHandlingListVo>}
	 */
	IPage<InsuranceRefundHandlingListVo> getInsuranceRefundHandlingPageList(Page<InsuranceRefundHandlingParam> page, InsuranceRefundHandlingParam param);

	/**
	 * 减员办理列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @return {@link List< InsuranceRefundHandlingListVo>}
	 */
	List<InsuranceRefundHandlingListVo> getInsuranceRefundHandlingList(InsuranceRefundOperationParam param);

	/**
	 * 减员办理
	 *
	 * @author zhaji
	 * @param insuranceDetail 办理类
	 * @return {@link R}
	 */
	R updateInsuranceRefund(InsuranceRefundListParam insuranceDetail);

	/**
	 * 变更结算月
	 *
	 * @author zhaji
	 * @param settleMonthCheckList 变更列表
	 * @return {@link R}
	 */
	R settleMonthChange(List<SettleMonthChangeCheckParam> settleMonthCheckList);

	/**
	 * 变更所属项目
	 *
	 * @author zhaji
	 * @param deptChangeCheckList 变更列表
	 * @return {@link R}
	 */
	R deptChange(List<DeptChangeCheckParam> deptChangeCheckList);

	/**
	 * 根据保险公司名称查询保单明细
	 *
	 * @author zhaji
	 * @param companyName 保险公司名称
	 * @return {@link R}
	 */
	R selectByCompanyName(String companyName);

	/**
	 * 根据险种id查询保单明细
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link R}
	 */
	R selectByTypeId(String id);

	/**
	 * 出险
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link R}
	 */
	R updateIsUse(String id);
}
