package com.yifu.cloud.plus.v1.yifu.insurances.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceTypeVo;

import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_type(险种表)】的数据库操作Service
* @createDate 2022-07-18 17:19:23
*/
public interface TInsuranceTypeService extends IService<TInsuranceType> {
	/**
	 * 险种分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param insuranceType 分页查询参数
	 * @return {@link IPage< TInsuranceType>}
	 */
	IPage<InsuranceTypeVo> pageDiy(Page page,TInsuranceType insuranceType);

	/**
	 * 新增险种信息
	 *
	 * @author zhaji
	 * @param insuranceType 新增参数
	 * @return {@link R}
	 */
	R saveInsuranceType(TInsuranceType insuranceType);

	/**
	 * 查看险种详情
	 *
	 * @author zhaji
	 * @param id 险种id
	 * @return {@link InsuranceTypeVo}
	 */
	R getInsuranceTypeDetail(String id);

	/**
	 * 修改险种信息
	 *
	 * @author zhaji
	 * @param insuranceType
	 * @return {@link R}
	 */
	R updateInsuranceType(TInsuranceType insuranceType);

	/**
	 * 查询险种列表
	 *
	 * @author zhaji
	 * @param insuranceType
	 * @return {@link List< TInsuranceType>}
	 */
	R getInsuranceTypeList(TInsuranceType insuranceType);
}
