package com.yifu.cloud.plus.v1.yifu.insurances.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.TInsuranceCompanyMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceCompanyService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceDetailService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_company(保险公司表)】的数据库操作Service实现
* @createDate 2022-07-18 17:19:09
*/
@Service
public class TInsuranceCompanyServiceImpl extends ServiceImpl<TInsuranceCompanyMapper, TInsuranceCompany> implements TInsuranceCompanyService {


	@Resource
	private TInsuranceDetailService insuranceDetailService;

	@Override
	public IPage<TInsuranceCompany> pageDiy(Page page, TInsuranceCompany insuranceCompany) {
		LambdaQueryWrapper<TInsuranceCompany> wrapper = new LambdaQueryWrapper<>();
		wrapper.orderByDesc(TInsuranceCompany::getCreateTime);
		return this.baseMapper.selectPage(page,wrapper);
	}

	@Override
	public R saveInsuranceCompany(TInsuranceCompany insuranceCompany) {
		if(Common.isEmpty(insuranceCompany)){
			return R.failed("新增的信息为空");
		}
		YifuUser user = SecurityUtils.getUser();
		String billingType = insuranceCompany.getBillingType();
		if (!CommonConstants.ZERO_STRING.equals(billingType) && !CommonConstants.ONE_STRING.equals(billingType)){
			return R.failed("计费方式格式不正确");
		}
		boolean b = companyIsExists(insuranceCompany.getCompanyName());
		if (!b){
			insuranceCompany.setCreateBy(user.getId());
			insuranceCompany.setCreateName(user.getNickname());
			insuranceCompany.setCreateTime(LocalDateTime.now());
			insuranceCompany.setDeleteFlag(CommonConstants.ZERO_INT);
			return R.ok(save(insuranceCompany),"新增成功");
		}else{
			return R.failed("当前保险公司已存在");
		}
	}

	/**
	 * 修改保险公司
	 *
	 * @author zhaji
	 * @param insuranceCompany 修改类
	 * @return {@link R}
	 */
	@Override
	public R updateInsuranceCompany(TInsuranceCompany insuranceCompany) {
		YifuUser user = SecurityUtils.getUser();
		String id = insuranceCompany.getId();
		if (StringUtils.isEmpty(id)){
			return R.failed("要修改的保险公司id为空");
		}
		String billingType = insuranceCompany.getBillingType();
		if (!CommonConstants.ZERO_STRING.equals(billingType) && !CommonConstants.ONE_STRING.equals(billingType)){
			return R.failed("计费方式格式不正确");
		}
		LambdaQueryWrapper<TInsuranceCompany> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceCompany::getId,id).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceCompany one = this.getOne(queryWrapper);
		if (Common.isEmpty(one)){
			return R.failed("要修改的保险公司不存在或已被删除");
		}
		String companyName = one.getCompanyName();
		//如果当前保险公司名称和修改后的名称不同
		if (!companyName.equals(insuranceCompany.getCompanyName())){
			//校验旧的保险公司名称是否已存在对应的商险信息
			LambdaQueryWrapper<TInsuranceDetail> detailQueryWrapper = new LambdaQueryWrapper<>();
			detailQueryWrapper.eq(TInsuranceDetail::getInsuranceCompanyName,companyName)
					.eq(TInsuranceDetail::getDeleteFlag,CommonConstants.ZERO_INT);
			List<TInsuranceDetail> list = insuranceDetailService.list(detailQueryWrapper);
			if (Common.isNotEmpty(list)){
				return R.failed("当前保险公司的名称已存在对应的商险信息，不能进行修改");
			}else{
				//校验新的保险公司名称在数据库中是否存在
				boolean b = companyIsExists(insuranceCompany.getCompanyName());
				if(b){
					return R.failed("当前保险公司名称已存在");
				}else {
					return R.ok(updateById(insuranceCompany));
				}
			}
		}else{
			insuranceCompany.setUpdateBy(user.getId());
			insuranceCompany.setUpdateTime(LocalDateTime.now());
			return R.ok(updateById(insuranceCompany));
		}
	}
	/**
	 * 删除保险公司信息
	 *
	 * @author zhaji
	 * @param id 保险公司id
	 * @return {@link R}
	 */
	@Override
	public R deleteById(String id) {
		YifuUser user = SecurityUtils.getUser();
		LambdaQueryWrapper<TInsuranceCompany> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceCompany::getId,id).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceCompany one = this.getOne(queryWrapper);
		if(Common.isEmpty(one)){
			return R.failed("当前保险公司不存在");
		}else {
			LambdaUpdateWrapper<TInsuranceCompany> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(TInsuranceCompany::getId,id)
						 .set(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT)
						 .set(TInsuranceCompany :: getUpdateBy,user.getId())
						 .set(TInsuranceCompany :: getUpdateTime,LocalDateTime.now());
			return R.ok(update(updateWrapper));
		}
	}

	/**
	 * 查询当前保险公司列表
	 *
	 * @author zhaji
	 * @return {@link List< TInsuranceCompany>}
	 */
	@Override
	public List<TInsuranceCompany> getInsuranceCompanyList() {
		LambdaQueryWrapper<TInsuranceCompany> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		return list(queryWrapper);
	}

	/**
	 * 校验保险公司是否存在
	 *
	 * @author zhaji
	 * @param companyName 保险公司名称
	 * @return {@link boolean}
	 */
	public boolean companyIsExists(String companyName){
		LambdaQueryWrapper<TInsuranceCompany> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceCompany::getCompanyName,companyName).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceCompany one = this.getOne(queryWrapper);
		if(Common.isEmpty(one)){
			return false;
		}else{
			return true;
		}
	}
}
