package com.yifu.cloud.plus.v1.yifu.insurances.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.UpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeRate;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.TInsuranceTypeRateMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceTypeRateService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceTypeService;
import com.yifu.cloud.plus.v1.yifu.insurances.util.ValidityUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_type_rate(费率表)】的数据库操作Service实现
* @createDate 2022-07-18 17:19:33
*/
@Service
public class TInsuranceTypeRateServiceImpl extends ServiceImpl<TInsuranceTypeRateMapper, TInsuranceTypeRate> implements TInsuranceTypeRateService {

	@Resource
	private TInsuranceTypeService insuranceTypeService;

	/**
	 * 根据险种id查询费率列表
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link List< TInsuranceTypeRate>}
	 */
	@Override
	public R getInsuranceTypeRateList(String id) {
		if (Common.isEmpty(id)){
			return R.failed("险种id为空");
		}
		TInsuranceType byId = insuranceTypeService.getById(id);
		if ( Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("当前险种信息不存在或已被删除");
		}
		LambdaQueryWrapper<TInsuranceTypeRate> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceTypeRate::getDeleteFlag, CommonConstants.ZERO_INT).eq(TInsuranceTypeRate::getInsuranceTypeId,id);
		return R.ok(list(queryWrapper));
	}

	/**
	 * 删除费率
	 *
	 * @author zhaji
	 * @param id 费率id
	 * @return {@link R}
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public R deleteInsuranceTypeRate(String id) {
		YifuUser user = SecurityUtils.getUser();
		if(Common.isEmpty(id)){
			return R.failed("费率id不能为空");
		}
		TInsuranceTypeRate byId = getById(id);
		if (Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("费率信息不存在或已被删除");
		}
		LambdaUpdateWrapper<TInsuranceTypeRate> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(TInsuranceTypeRate::getId,id)
				.set(TInsuranceTypeRate::getDeleteFlag, CommonConstants.ONE_INT)
				.set(TInsuranceTypeRate :: getUpdateBy,user.getId())
				.set(TInsuranceTypeRate :: getUpdateTime, LocalDateTime.now());
		return R.ok(update(updateWrapper),"删除费率信息成功");
	}

	/**
	 * 新增费率
	 *
	 * @author zhaji
	 * @param insuranceTypeRate 费率信息
	 * @return {@link R}
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public R saveInsuranceTypeRate(TInsuranceTypeRate insuranceTypeRate) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(insuranceTypeRate)){
			return R.failed("新增的费率信息为空");
		}
		String insuranceTypeId = insuranceTypeRate.getInsuranceTypeId();
		TInsuranceType byId = insuranceTypeService.getById(insuranceTypeId);
		if ( Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("当前险种信息不存在或已被删除");
		}
		String month = insuranceTypeRate.getMonth();
		if (!ValidityUtil.isMonth(month)){
			return R.failed("当前月份格式不正确");
		}
		String rate = insuranceTypeRate.getRate();
		if (!Common.isNumber(rate)){
			return R.failed("当前费率格式不正确");
		}
		LambdaQueryWrapper<TInsuranceTypeRate> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceTypeRate::getDeleteFlag, CommonConstants.ZERO_INT).eq(TInsuranceTypeRate::getInsuranceTypeId,insuranceTypeId)
				.eq(TInsuranceTypeRate :: getRate,insuranceTypeRate.getRate()).eq(TInsuranceTypeRate:: getMonth ,insuranceTypeRate.getMonth());
		List<TInsuranceTypeRate> list = this.list(queryWrapper);
		if (list.isEmpty()){
			insuranceTypeRate.setDeleteFlag(CommonConstants.ZERO_INT);
			insuranceTypeRate.setCreateBy(user.getId());
			insuranceTypeRate.setCreateName(user.getNickname());
			insuranceTypeRate.setCreateTime(LocalDateTime.now());
			return R.ok(this.baseMapper.insert(insuranceTypeRate));
		}else{
			return R.failed("当前险种已存在相同的费率");
		}
	}

}
