package com.yifu.cloud.plus.v1.yifu.insurances.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeRate;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeStandard;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.TInsuranceTypeMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceCompanyService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceDetailService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceTypeService;
import com.yifu.cloud.plus.v1.yifu.insurances.util.BeanCopyUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.util.ValidityUtil;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceTypeVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_type(险种表)】的数据库操作Service实现
* @createDate 2022-07-18 17:19:23
*/
@Service
public class TInsuranceTypeServiceImpl extends ServiceImpl<TInsuranceTypeMapper, TInsuranceType> implements TInsuranceTypeService {

	@Resource
	private TInsuranceCompanyService insuranceCompanyService;

	/**
	 * 险种分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param insuranceType 分页查询参数
	 * @return {@link IPage< TInsuranceType>}
	 */
	@Override
	public IPage<InsuranceTypeVo> pageDiy(Page page, TInsuranceType insuranceType) {
		return this.baseMapper.selectInsuranceTypePage(page,insuranceType);
	}

	/**
	 * 新增险种信息
	 *
	 * @author zhaji
	 * @param insuranceType 新增参数
	 * @return {@link R}
	 */
	@Override
	public R saveInsuranceType(TInsuranceType insuranceType) {
		YifuUser user = SecurityUtils.getUser();
		String companyId = insuranceType.getInsuranceCompanyId();
		String bankNo = insuranceType.getBankNo();
		if(!Common.isNumber(bankNo)){
			return R.failed("银行账号格式不正确");
		}
		LambdaQueryWrapper<TInsuranceCompany> companyWrapper = new LambdaQueryWrapper<>();
		companyWrapper.eq(TInsuranceCompany::getId,companyId).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceCompany insuranceCompany = insuranceCompanyService.getOne(companyWrapper);
		if(Common.isEmpty(insuranceCompany)){
			return R.failed("所属保险公司不存在或已被删除");
		}
		LambdaQueryWrapper<TInsuranceType> typeWrapper = new LambdaQueryWrapper<>();
		typeWrapper.eq(TInsuranceType :: getInsuranceCompanyId ,companyId).eq(TInsuranceType::getName,insuranceType.getName()).eq(TInsuranceType::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceType type = getOne(typeWrapper);
		if (!Common.isEmpty(type)){
			return R.failed("当前险种已存在");
		}else{
			insuranceType.setDeleteFlag(CommonConstants.ZERO_INT);
			insuranceType.setCreateBy(user.getId());
			insuranceType.setCreateName(user.getNickname());
			insuranceType.setCreateTime(LocalDateTime.now());
			return R.ok(save(insuranceType));
		}
	}

	/**
	 * 查看险种详情
	 *
	 * @author zhaji
	 * @param id 险种id
	 * @return {@link InsuranceTypeVo}
	 */
	@Override
	public R getInsuranceTypeDetail(String id) {
		if (Common.isEmpty(id)){
			return R.failed("险种ID不能为空");
		}
		InsuranceTypeVo insuranceTypeVo = new InsuranceTypeVo();
		TInsuranceType byId = getById(id);
		if(Common.isEmpty(byId) || byId.getDeleteFlag() == CommonConstants.ONE_INT){
			return R.failed("当前险种信息不存在或已被删除");
		}
		BeanCopyUtils.copyProperties(byId,insuranceTypeVo);
		List<TInsuranceTypeRate> tInsuranceTypeRates = this.baseMapper.selectInsuranceTypeRateList(id);
		List<TInsuranceTypeStandard> tInsuranceTypeStandards = this.baseMapper.selectInsuranceTypeStandardList(id);
		insuranceTypeVo.setInsuranceTypeRateList(tInsuranceTypeRates);
		insuranceTypeVo.setInsuranceTypeStandardList(tInsuranceTypeStandards);
		return R.ok(insuranceTypeVo);
	}

	/**
	 * 修改险种信息
	 *
	 * @author zhaji
	 * @param insuranceType 险种信息
	 * @return {@link R}
	 */
	@Override
	public R updateInsuranceType(TInsuranceType insuranceType) {
		if (Common.isEmpty(insuranceType.getId())){
			return R.failed("险种ID不能为空");
		}
		TInsuranceType byId = getById(insuranceType.getId());
		if(Common.isEmpty(byId) || byId.getDeleteFlag() == CommonConstants.ONE_INT){
			return R.failed("当前险种信息不存在或已被删除");
		}
		if(byId.getName().equals(insuranceType.getName())){
			return R.ok(this.updateById(insuranceType),"修改险种信息成功");
		}else{
			LambdaQueryWrapper<TInsuranceType> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.eq(TInsuranceType::getName,insuranceType.getName())
					.eq(TInsuranceType::getInsuranceCompanyId,insuranceType.getInsuranceCompanyId())
					.eq(TInsuranceType::getDeleteFlag,CommonConstants.ZERO_INT);
			TInsuranceType one = this.getOne(queryWrapper);
			if (Common.isEmpty(one)){
				return R.ok(this.updateById(insuranceType),"修改险种信息成功");
			}else{
				return R.failed("当前险种名称已存在");
			}
		}
	}

	/**
	 * 查询险种列表
	 *
	 * @author zhaji
	 * @param insuranceType 险种信息
	 * @return {@link List< TInsuranceType>}
	 */
	@Override
	public R getInsuranceTypeList(TInsuranceType insuranceType) {
		String companyId = insuranceType.getInsuranceCompanyId();
		LambdaQueryWrapper<TInsuranceType> query = new LambdaQueryWrapper<>();
		query.eq(TInsuranceType::getDeleteFlag,CommonConstants.ZERO_INT);

		if(StringUtils.isBlank(companyId)){
			List<TInsuranceType> list = this.list(query);
			return R.ok(list,"查询险种列表成功");
		}else{
			LambdaQueryWrapper<TInsuranceCompany> companyWrapper = new LambdaQueryWrapper<>();
			companyWrapper.eq(TInsuranceCompany::getId,companyId).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
			TInsuranceCompany insuranceCompany = insuranceCompanyService.getOne(companyWrapper);
			if(Common.isEmpty(insuranceCompany)){
				return R.failed("所属保险公司不存在或已被删除");
			}else{
				query.eq(TInsuranceType::getInsuranceCompanyId,companyId);
				List<TInsuranceType> list = this.list(query);
				return R.ok(list,"查询险种列表成功");
			}
		}
	}

}
