package com.yifu.cloud.plus.v1.yifu.insurances.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeRate;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeStandard;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.TInsuranceTypeStandardMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceDetailService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceTypeService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.TInsuranceTypeStandardService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_type_standard(购买标准表)】的数据库操作Service实现
* @createDate 2022-07-18 17:19:41
*/
@Service
public class TInsuranceTypeStandardServiceImpl extends ServiceImpl<TInsuranceTypeStandardMapper, TInsuranceTypeStandard> implements TInsuranceTypeStandardService {
	@Resource
	private TInsuranceTypeService insuranceTypeService;

	@Resource
	private TInsuranceDetailService insuranceDetailService;

	/**
	 * 查询购买标准列表
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link R}
	 */
	@Override
	public R getInsuranceTypeStandard(String id) {
		if (Common.isEmpty(id)){
			return R.failed("险种id为空");
		}
		TInsuranceType byId = insuranceTypeService.getById(id);
		if ( Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("当前险种信息不存在或已被删除");
		}
		LambdaQueryWrapper<TInsuranceTypeStandard> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceTypeStandard::getDeleteFlag, CommonConstants.ZERO_INT).eq(TInsuranceTypeStandard::getInsuranceTypeId,id);
		return R.ok(list(queryWrapper));
	}

	/**
	 * 删除购买标准
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link R}
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public R deleteInsuranceTypeStandard(String id) {
		YifuUser user = SecurityUtils.getUser();
		if(Common.isEmpty(id)){
			return R.failed("购买标准id不能为空");
		}
		TInsuranceTypeStandard byId = getById(id);
		if (Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("购买标准信息不存在或已被删除");
		}
		LambdaQueryWrapper<TInsuranceDetail> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceDetail::getInsuranceTypeId,byId.getInsuranceTypeId())
				.eq(TInsuranceDetail::getBuyStandard,byId.getBuyStandard())
				.eq(TInsuranceDetail::getDeleteFlag,CommonConstants.ZERO_INT);
		List<TInsuranceDetail> list = insuranceDetailService.list(queryWrapper);
		if (Common.isNotEmpty(list)){
			return R.failed("当前险种的购买标准已存在对应的商险信息，不能删除");
		}
		LambdaUpdateWrapper<TInsuranceTypeStandard> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(TInsuranceTypeStandard::getId,id)
				.set(TInsuranceTypeStandard::getDeleteFlag, CommonConstants.ONE_INT)
				.set(TInsuranceTypeStandard :: getUpdateBy,user.getId())
				.set(TInsuranceTypeStandard :: getUpdateTime,LocalDateTime.now());
		return R.ok(update(updateWrapper),"删除购买标准成功");
	}
	/**
	 * 新增购买标准
	 *
	 * @author zhaji
	 * @param insuranceTypeStandard
	 * @return {@link R}
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public R saveInsuranceTypeStandard(TInsuranceTypeStandard insuranceTypeStandard) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(insuranceTypeStandard)){
			return R.failed("新增的购买标准信息为空");
		}
		Long insuranceTypeId = insuranceTypeStandard.getInsuranceTypeId();
		TInsuranceType byId = insuranceTypeService.getById(insuranceTypeId);
		if ( Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("当前险种信息不存在或已被删除");
		}
		String buyStandard = insuranceTypeStandard.getBuyStandard();
		String medicalQuota = insuranceTypeStandard.getMedicalQuota();
		String dieDisableQuota = insuranceTypeStandard.getDieDisableQuota();
		if (!Common.isNumber(buyStandard)){
			return R.failed("当前购买标准格式不正确");
		}
		if (!Common.isNumber(medicalQuota)){
			return R.failed("当前医疗额度格式不正确");
		}
		if (!Common.isNumber(dieDisableQuota)){
			return R.failed("当前身故或残疾额度格式不正确");
		}
		LambdaQueryWrapper<TInsuranceTypeStandard> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceTypeStandard::getInsuranceTypeId,insuranceTypeStandard.getInsuranceTypeId())
				.eq(TInsuranceTypeStandard::getBuyStandard,insuranceTypeStandard.getBuyStandard())
				.eq(TInsuranceTypeStandard::getDeleteFlag,CommonConstants.ZERO_INT);
		List<TInsuranceTypeStandard> list = list(queryWrapper);
		if(list.isEmpty()){
			insuranceTypeStandard.setDeleteFlag(CommonConstants.ZERO_INT);
			insuranceTypeStandard.setCreateBy(user.getId());
			insuranceTypeStandard.setCreateName(user.getNickname());
			insuranceTypeStandard.setCreateTime(LocalDateTime.now());
			return R.ok(this.baseMapper.insert(insuranceTypeStandard),"新增购买标准成功");
		}else{
			return R.failed("当前险种下的购买标准已存在");
		}

	}
}
