/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 社保、公积金基数配置
 *
 * @author hgw
 * @date 2022-07-11 18:13:22
 */
@Data
@TableName("sys_base_set_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保、公积金基数配置")
public class SysBaseSetInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelAttribute(name = "主键")
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String id;

	/**
	 * 缴纳地-省（社保或公积金）
	 */
	@ExcelAttribute(name = "缴纳地-省（社保或公积金）")
	@Schema(description = "缴纳地-省（社保或公积金）")
	@ExcelProperty("缴纳地-省（社保或公积金）")
	private Integer province;

	/**
	 * 缴纳地-市（社保或公积金）
	 */
	@ExcelAttribute(name = "缴纳地-市（社保或公积金）")
	@Schema(description = "缴纳地-市（社保或公积金）")
	@ExcelProperty("缴纳地-市（社保或公积金）")
	private Integer city;

	/**
	 * 缴纳地-县（社保或公积金）
	 */
	@ExcelAttribute(name = "缴纳地-县（社保或公积金）")
	@Schema(description = "缴纳地-县（社保或公积金）")
	@ExcelProperty("缴纳地-县（社保或公积金）")
	private Integer town;

	/**
	 * 适用周期-开始时间（社保或公积金）
	 */
	@ExcelAttribute(name = "适用周期-开始时间（社保或公积金）")
	@Schema(description = "适用周期-开始时间（社保或公积金）")
	@ExcelProperty("适用周期-开始时间（社保或公积金）")
	private Date applyStartDate;

	/**
	 * 适用周期-结束时间（社保或公积金）
	 */
	@ExcelAttribute(name = "适用周期-结束时间（社保或公积金）")
	@Schema(description = "适用周期-结束时间（社保或公积金）")
	@ExcelProperty("适用周期-结束时间（社保或公积金）")
	private Date applyEndDate;

	/**
	 * 基数上限（社保或公积金）
	 */
	@ExcelAttribute(name = "基数上限（社保或公积金）")
	@Schema(description = "基数上限（社保或公积金）")
	@ExcelProperty("基数上限（社保或公积金）")
	private BigDecimal upperLimit;

	/**
	 * 基数下限（社保或公积金）
	 */
	@ExcelAttribute(name = "基数下限（社保或公积金）")
	@Schema(description = "基数下限（社保或公积金）")
	@ExcelProperty("基数下限（社保或公积金）")
	private BigDecimal lowerLimit;

	/**
	 * 补缴政策（社保或公积金）
	 */
	@ExcelAttribute(name = "补缴政策（社保或公积金）")
	@Schema(description = "补缴政策（社保或公积金）")
	@ExcelProperty("补缴政策（社保或公积金）")
	private String payPolicy;

	/**
	 * 0.社保 1.公积金
	 */
	@ExcelAttribute(name = "0.社保 1.公积金")
	@Schema(description = "0.社保 1.公积金")
	@ExcelProperty("0.社保 1.公积金")
	private String baseType;

	/**
	 * 单位养老缴纳比例
	 */
	@ExcelAttribute(name = "单位养老缴纳比例")
	@Schema(description = "单位养老缴纳比例")
	@ExcelProperty("单位养老缴纳比例")
	private BigDecimal unitPersionPro;

	/**
	 * 单位医疗缴纳比例
	 */
	@ExcelAttribute(name = "单位医疗缴纳比例")
	@Schema(description = "单位医疗缴纳比例")
	@ExcelProperty("单位医疗缴纳比例")
	private BigDecimal unitMedicalPro;

	/**
	 * 单位失业缴纳比例
	 */
	@ExcelAttribute(name = "单位失业缴纳比例")
	@Schema(description = "单位失业缴纳比例")
	@ExcelProperty("单位失业缴纳比例")
	private BigDecimal unitUnemploymentPro;

	/**
	 * 单位工伤缴纳比例
	 */
	@ExcelAttribute(name = "单位工伤缴纳比例")
	@Schema(description = "单位工伤缴纳比例")
	@ExcelProperty("单位工伤缴纳比例")
	private BigDecimal unitInjuryPro;

	/**
	 * 单位生育缴纳比例-已删除
	 */
	@ExcelAttribute(name = "单位生育缴纳比例-已删除")
	@Schema(description = "单位生育缴纳比例-已删除")
	@ExcelProperty("单位生育缴纳比例-已删除")
	private BigDecimal unitBirthPro;

	/**
	 * 单位比例合计
	 */
	@ExcelAttribute(name = "单位比例合计")
	@Schema(description = "单位比例合计")
	@ExcelProperty("单位比例合计")
	private BigDecimal unitProSum;

	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例")
	@Schema(description = "个人养老比例")
	@ExcelProperty("个人养老比例")
	private BigDecimal personalPersionPro;

	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例")
	@Schema(description = "个人医疗比例")
	@ExcelProperty("个人医疗比例")
	private BigDecimal personalMedicalPro;

	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例")
	@Schema(description = "个人失业比例")
	@ExcelProperty("个人失业比例")
	private BigDecimal personalUnemploymentPro;

	/**
	 * 个人比例合计
	 */
	@ExcelAttribute(name = "个人比例合计")
	@Schema(description = "个人比例合计")
	@ExcelProperty("个人比例合计")
	private BigDecimal personalProSum;

	/**
	 * 是否大病:  0收取；1不收取
	 */
	@ExcelAttribute(name = "是否大病:  0收取；1不收取")
	@Schema(description = "是否大病:  0收取；1不收取")
	@ExcelProperty("是否大病:  0收取；1不收取")
	private String isIllness;

	/**
	 * 新员工入职是否收费 0.是 1.否
	 */
	@ExcelAttribute(name = "新员工入职是否收费 0.是 1.否")
	@Schema(description = "新员工入职是否收费 0.是 1.否")
	@ExcelProperty("新员工入职是否收费 0.是 1.否")
	private String isChargePersonal;

	/**
	 * 单位大病金额（元/人）--按定值
	 */
	@ExcelAttribute(name = "单位大病金额（元/人）--按定值")
	@Schema(description = "单位大病金额（元/人）--按定值")
	@ExcelProperty("单位大病金额（元/人）--按定值")
	private BigDecimal chargeCompany;

	/**
	 * 个人大病金额（元/人）--按定值
	 */
	@ExcelAttribute(name = "个人大病金额（元/人）--按定值")
	@Schema(description = "个人大病金额（元/人）--按定值")
	@ExcelProperty("个人大病金额（元/人）--按定值")
	private BigDecimal chargePersonal;

	/**
	 * 大病缴纳周期：收取方式  0.按年 1.按月
	 */
	@ExcelAttribute(name = "大病缴纳周期：收取方式  0.按年 1.按月")
	@Schema(description = "大病缴纳周期：收取方式  0.按年 1.按月")
	@ExcelProperty("大病缴纳周期：收取方式  0.按年 1.按月")
	private String collectType;

	/**
	 * 大病单位缴纳金额--按比例
	 */
	@ExcelAttribute(name = "大病单位缴纳金额--按比例")
	@Schema(description = "大病单位缴纳金额--按比例")
	@ExcelProperty("大病单位缴纳金额--按比例")
	private BigDecimal payCompany;

	/**
	 * 单位大病比例
	 */
	@ExcelAttribute(name = "单位大病比例")
	@Schema(description = "单位大病比例")
	@ExcelProperty("单位大病比例")
	private BigDecimal payCompanyPro;

	/**
	 * 大病个人缴纳金额--按比例
	 */
	@ExcelAttribute(name = "大病个人缴纳金额--按比例")
	@Schema(description = "大病个人缴纳金额--按比例")
	@ExcelProperty("大病个人缴纳金额--按比例")
	private BigDecimal payPersonal;

	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例")
	@Schema(description = "个人大病比例")
	@ExcelProperty("个人大病比例")
	private BigDecimal payPersonalPro;

	/**
	 * 缴纳月份：周期为年--收取月份  1到12月份
	 */
	@ExcelAttribute(name = "缴纳月份：周期为年--收取月份  1到12月份")
	@Schema(description = "缴纳月份：周期为年--收取月份  1到12月份")
	@ExcelProperty("缴纳月份：周期为年--收取月份  1到12月份")
	private Integer collectMoth;

	/**
	 * 单边缴费额度下--公积金
	 */
	@ExcelAttribute(name = "单边缴费额度下--公积金")
	@Schema(description = "单边缴费额度下--公积金")
	@ExcelProperty("单边缴费额度下--公积金")
	private BigDecimal fundPayLowerLimit;

	/**
	 * 单边缴费额度上限--公积金
	 */
	@ExcelAttribute(name = "单边缴费额度上限--公积金")
	@Schema(description = "单边缴费额度上限--公积金")
	@ExcelProperty("单边缴费额度上限--公积金")
	private BigDecimal fundPayUpperLimit;

	/**
	 * 单边小数点：公积金
	 */
	@ExcelAttribute(name = "单边小数点：公积金")
	@Schema(description = "单边小数点：公积金")
	@ExcelProperty("单边小数点：公积金")
	private Integer fundPayPoint;

	/**
	 * 公积金类型 0.市直  1. 省直
	 */
	@ExcelAttribute(name = "公积金类型 0.市直  1. 省直")
	@Schema(description = "公积金类型 0.市直  1. 省直")
	@ExcelProperty("公积金类型 0.市直  1. 省直")
	private Integer fundPayType;

	/**
	 * 单位公积金比例
	 */
	@ExcelAttribute(name = "单位公积金比例")
	@Schema(description = "单位公积金比例")
	@ExcelProperty("单位公积金比例")
	private BigDecimal housingFundCompamyPro;

	/**
	 * 个人公积金比例
	 */
	@ExcelAttribute(name = "个人公积金比例")
	@Schema(description = "个人公积金比例")
	@ExcelProperty("个人公积金比例")
	private BigDecimal housingFundPersonalPro;

	/**
	 * 部门关联ID
	 */
	@ExcelAttribute(name = "部门关联ID")
	@Schema(description = "部门关联ID")
	@ExcelProperty("部门关联ID")
	private String departId;

	/**
	 * 0.在用1.终止2过期
	 */
	@ExcelAttribute(name = "0.在用1.终止2过期")
	@Schema(description = "0.在用1.终止2过期")
	@ExcelProperty("0.在用1.终止2过期")
	private Integer status;

	/**
	 * 缴纳方式：周期为月--取值方式 0.按定值1比例
	 */
	@ExcelAttribute(name = "缴纳方式：周期为月--取值方式 0.按定值1比例")
	@Schema(description = "缴纳方式：周期为月--取值方式 0.按定值1比例")
	@ExcelProperty("缴纳方式：周期为月--取值方式 0.按定值1比例")
	private String valueType;

	/**
	 * 是否可以补缴： 0：是，1：否
	 */
	@ExcelAttribute(name = "是否可以补缴： 0：是，1：否")
	@Schema(description = "是否可以补缴： 0：是，1：否")
	@ExcelProperty("是否可以补缴： 0：是，1：否")
	private String canOverpay;

	/**
	 * 最大补缴期限
	 */
	@ExcelAttribute(name = "最大补缴期限")
	@Schema(description = "最大补缴期限")
	@ExcelProperty("最大补缴期限")
	private Integer overpayNumber;

	/**
	 * 是否含起缴当月： 0：是，1：否
	 */
	@ExcelAttribute(name = "是否含起缴当月： 0：是，1：否")
	@Schema(description = "是否含起缴当月： 0：是，1：否")
	@ExcelProperty("是否含起缴当月： 0：是，1：否")
	private String haveThisMonth;

	/**
	 * 补缴险种-是否能补缴养老0是1否
	 */
	@ExcelAttribute(name = "补缴险种-是否能补缴养老0是1否")
	@Schema(description = "补缴险种-是否能补缴养老0是1否")
	@ExcelProperty("补缴险种-是否能补缴养老0是1否")
	private String insurancePension;

	/**
	 * 补缴险种-是否能补缴医疗0是1否
	 */
	@ExcelAttribute(name = "补缴险种-是否能补缴医疗0是1否")
	@Schema(description = "补缴险种-是否能补缴医疗0是1否")
	@ExcelProperty("补缴险种-是否能补缴医疗0是1否")
	private String insuranceMedical;

	/**
	 * 补缴险种-是否能补缴失业0是1否
	 */
	@ExcelAttribute(name = "补缴险种-是否能补缴失业0是1否")
	@Schema(description = "补缴险种-是否能补缴失业0是1否")
	@ExcelProperty("补缴险种-是否能补缴失业0是1否")
	private String insuranceUnemployment;

	/**
	 * 补缴险种-是否能补缴工伤0是1否
	 */
	@ExcelAttribute(name = "补缴险种-是否能补缴工伤0是1否")
	@Schema(description = "补缴险种-是否能补缴工伤0是1否")
	@ExcelProperty("补缴险种-是否能补缴工伤0是1否")
	private String insuranceInjury;

	/**
	 * 补缴险种-是否能补缴生育0是1否
	 */
	@ExcelAttribute(name = "补缴险种-是否能补缴生育0是1否")
	@Schema(description = "补缴险种-是否能补缴生育0是1否")
	@ExcelProperty("补缴险种-是否能补缴生育0是1否")
	private String insuranceBirth;

	/**
	 * 补缴险种-是否能补缴大病0是1否
	 */
	@ExcelAttribute(name = "补缴险种-是否能补缴大病0是1否")
	@Schema(description = "补缴险种-是否能补缴大病0是1否")
	@ExcelProperty("补缴险种-是否能补缴大病0是1否")
	private String insuranceBigailment;

	/**
	 * 补缴险种-补缴是否采用最新基数0是1否
	 */
	@ExcelAttribute(name = "补缴险种-补缴是否采用最新基数0是1否")
	@Schema(description = "补缴险种-补缴是否采用最新基数0是1否")
	@ExcelProperty("补缴险种-补缴是否采用最新基数0是1否")
	private String insuranceIsLatestCardinality;

	/**
	 * 删除标志0正常1删除
	 */
	@ExcelAttribute(name = "删除标志0正常1删除")
	@Schema(description = "删除标志0正常1删除")
	@ExcelProperty("删除标志0正常1删除")
	private String deleteFlag;

	/**
	 * 社保户名称
	 */
	@ExcelAttribute(name = "社保户名称")
	@Schema(description = "社保户名称")
	@ExcelProperty("社保户名称")
	private String departName;

	@ExcelAttribute(name = "执行月份")
	@Schema(description = "执行月份")
	@ExcelProperty("执行月份")
	private String doMonth;

	@Schema(description = "适用月")
	@TableField(exist = false)
	private String applyDate;

	@Schema(description = "公积金比例List（保存时前端传参用）")
	@TableField(exist = false)
	private List<SysPayProportion> fundProList;


}
