/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 社保户公积金户数据
 *
 * @author fxj
 * @date 2022-07-12 08:53:19
 */
@Data
@TableName("sys_house_hold_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保户公积金户数据")
public class SysHouseHoldInfo extends BaseEntity {

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelAttribute(name = "id" )
    @Schema(description ="id")
    @ExcelProperty("id")
    private String id;

    /**
     * 所属机构ID
     */
    @ExcelAttribute(name = "所属机构ID" )
    @Schema(description ="所属机构ID")
    @ExcelProperty("所属机构ID")
    private String organId;

    /**
     * 户名
     */
    @ExcelAttribute(name = "户名" )
    @Schema(description ="户名")
    @ExcelProperty("户名")
    private String name;

    /**
     * 0启用1禁用
     */
    @ExcelAttribute(name = "0启用1禁用" )
    @Schema(description ="0启用1禁用")
    @ExcelProperty("0启用1禁用")
    private String delFlag;

    /**
     * 账户性质：0社保 1公积金
     */
    @ExcelAttribute(name = "账户性质：0社保 1公积金" )
    @Schema(description ="账户性质：0社保 1公积金")
    @ExcelProperty("账户性质：0社保 1公积金")
    private String type;

    /**
     * 缴纳地-省
     */
    @ExcelAttribute(name = "缴纳地-省" )
    @Schema(description ="缴纳地-省")
    @ExcelProperty("缴纳地-省")
    private String province;

    /**
     * 缴纳地-市
     */
    @ExcelAttribute(name = "缴纳地-市" )
    @Schema(description ="缴纳地-市")
    @ExcelProperty("缴纳地-市")
    private String city;

    /**
     * 缴纳地-县
     */
    @ExcelAttribute(name = "缴纳地-县" )
    @Schema(description ="缴纳地-县")
    @ExcelProperty("缴纳地-县")
    private String town;

    /**
     * 备注
     */
    @ExcelAttribute(name = "备注" )
    @Schema(description ="备注")
    @ExcelProperty("备注")
    private String rmark;

    /**
     * 所属机构名称
     */
    @ExcelAttribute(name = "所属机构名称" )
    @Schema(description ="所属机构名称")
    @ExcelProperty("所属机构名称")
    private String organName;

}
