/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 公积金政策对应的缴费比例表
 *
 * @author hgw
 * @date 2022-07-11 18:13:22
 */
@Data
@TableName("sys_pay_proportion")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "公积金政策对应的缴费比例表")
public class SysPayProportion extends BaseEntity {

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelAttribute(name = "id" )
    @Schema(description ="id")
    @ExcelProperty("id")
    private String id;

    /**
     * 住房公积金公司缴纳比例
     */
    @ExcelAttribute(name = "住房公积金公司缴纳比例" )
    @Schema(description ="住房公积金公司缴纳比例")
    @ExcelProperty("住房公积金公司缴纳比例")
    private Double companyPro;

    /**
     * 公积金住房个人缴纳比例
     */
    @ExcelAttribute(name = "公积金住房个人缴纳比例" )
    @Schema(description ="公积金住房个人缴纳比例")
    @ExcelProperty("公积金住房个人缴纳比例")
    private Double personalPro;

    /**
     * 关联公积金政策基数设置表ID
     */
    @ExcelAttribute(name = "关联公积金政策基数设置表ID" )
    @Schema(description ="关联公积金政策基数设置表ID")
    @ExcelProperty("关联公积金政策基数设置表ID")
    private String sysBaseSetId;


}
