/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
@TableName("t_audit_info" )
@Schema(description = "审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）" )
public class TAuditInfo implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键" )
	@ExcelProperty("主键" )
	private String id;
	/**
	 * 社保ID
	 */
	@Length(max = 32, message = "社保ID 不能超过32个字符" )
	@ExcelAttribute(name = "社保ID", maxLength = 32)
	@Schema(description = "社保ID" )
	@ExcelProperty("社保ID" )
	private String socialId;
	/**
	 * 审核状态（0wait/1success/2fail）
	 */
	@NotBlank(message = "审核状态（0wait/1success/2fail）不能为空" )
	@Length(max = 1, message = "审核状态（0wait/1success/2fail） 不能超过1个字符" )
	@ExcelAttribute(name = "审核状态（0wait/1success/2fail）", isNotEmpty = true, errorInfo = "审核状态（0wait/1success/2fail）不能为空", maxLength = 1)
	@Schema(description = "审核状态（0wait/1success/2fail）" )
	@ExcelProperty("审核状态（0wait/1success/2fail）" )
	private String auditStatus;
	/**
	 * 审核意见
	 */
	@NotBlank(message = "审核意见不能为空" )
	@Length(max = 200, message = "审核意见 不能超过200个字符" )
	@ExcelAttribute(name = "审核意见", isNotEmpty = true, errorInfo = "审核意见不能为空", maxLength = 200)
	@Schema(description = "审核意见" )
	@ExcelProperty("审核意见" )
	private String auditRemark;
	/**
	 * 审核人
	 */
	@NotBlank(message = "审核人不能为空" )
	@Length(max = 32, message = "审核人 不能超过32个字符" )
	@ExcelAttribute(name = "审核人", isNotEmpty = true, errorInfo = "审核人不能为空", maxLength = 32)
	@Schema(description = "审核人" )
	@ExcelProperty("审核人" )
	private String auditUser;
	/**
	 * 审核时间
	 */
	@NotBlank(message = "审核时间不能为空" )
	@ExcelAttribute(name = "审核时间", isNotEmpty = true, errorInfo = "审核时间不能为空", isDate = true)
	@Schema(description = "审核时间" )
	@ExcelProperty("审核时间" )
	private Date auditTime;
	/**
	 * 是否委托（0是/1否）
	 */
	@NotBlank(message = "是否委托（0是/1否）不能为空" )
	@Length(max = 1, message = "是否委托（0是/1否） 不能超过1个字符" )
	@ExcelAttribute(name = "是否委托（0是/1否）", isNotEmpty = true, errorInfo = "是否委托（0是/1否）不能为空", maxLength = 1)
	@Schema(description = "是否委托（0是/1否）" )
	@ExcelProperty("是否委托（0是/1否）" )
	private String isCommision;
	/**
	 * 公积金ID
	 */
	@Length(max = 32, message = "公积金ID 不能超过32个字符" )
	@ExcelAttribute(name = "公积金ID", maxLength = 32)
	@Schema(description = "公积金ID" )
	@ExcelProperty("公积金ID" )
	private String providentId;

	/**
	 * 身份证
	 */
	@ExcelAttribute(name = "身份证", maxLength = 32)
	@Schema(description = "身份证" )
	@ExcelProperty("身份证" )
	private String empIdcard;

	/**
	 * 派单id
	 */
	@Length(max = 32, message = "派单id 不能超过32个字符" )
	@ExcelAttribute(name = "派单id", maxLength = 32)
	@Schema(description = "派单id" )
	@ExcelProperty("派单id" )
	private String dispatchInfoId;
	/**
	 * type类型：0：其他；1：社保 2.公积金
	 */
	@NotBlank(message = "type类型不能为空" )
	@Length(max = 1, message = "type类型不能超过1个字符" )
	@ExcelAttribute(name = "type类型", isNotEmpty = true, errorInfo = "type类型不能为空", maxLength = 1)
	@Schema(description = "ype类型：0：其他；1：社保 2.公积金" )
	@ExcelProperty("type类型" )
	private String type;


	/**
	 * 部门---员工所在部门
	 */
	@ExcelAttribute(name = "部门")
	@Schema(description = "部门---员工所在部门" )
	private String organName;

	/**
	 * 操作内容
	 */
	@ExcelAttribute(name = "操作内容")
	@Schema(description = "操作内容" )
	private String title;

	/**
	 * 颜色： red  green  yellow  grey
	 */
	@ExcelAttribute(name = "颜色")
	@Schema(description = "颜色： red  green  yellow  grey" )
	private String color;

}
