/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 缴费库
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
@Data
@TableName("t_payment_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "缴费库")
public class TPaymentInfo extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 员工姓名
     */
    @ExcelAttribute(name = "员工姓名" )
    @Schema(description ="员工姓名")
    @ExcelProperty("员工姓名")
	@Size(max = 20, message = "员工姓名不可超过20位")
    private String empName;

    /**
     * 员工编码
     */
    @ExcelAttribute(name = "员工编码" )
    @Schema(description ="员工编码")
    @ExcelProperty("员工编码")
	@Size(max = 32, message = "员工编码不可超过32位")
    private String empNo;

    /**
     * 员工ID
     */
    @ExcelAttribute(name = "员工ID" )
    @Schema(description ="员工ID")
    @ExcelProperty("员工ID")
    private String empId;

    /**
     * 身份证号
     */
    @ExcelAttribute(name = "身份证号" )
    @Schema(description ="身份证号")
    @ExcelProperty("身份证号")
	@Size(max = 32, message = "身份证号不可超过32位")
    private String empIdcard;

    /**
     * 单位名称
     */
    @ExcelAttribute(name = "单位名称" )
    @Schema(description ="单位名称")
    @ExcelProperty("单位名称")
    private String unitId;

    /**
     * 项目名称
     */
    @ExcelAttribute(name = "项目名称" )
    @Schema(description ="项目名称")
    @ExcelProperty("项目名称")
    private String settleDomainId;

    /**
     * 社保户
     */
    @ExcelAttribute(name = "社保户" )
    @Schema(description ="社保户")
    @ExcelProperty("社保户")
    private String socialHousehold;

    /**
     * 社保编号
     */
    @ExcelAttribute(name = "社保编号" )
    @Schema(description ="社保编号")
    @ExcelProperty("社保编号")
    private String socialSecurityNo;

    /**
     * 社保缴纳地
     */
    @ExcelAttribute(name = "社保缴纳地" )
    @Schema(description ="社保缴纳地")
    @ExcelProperty("社保缴纳地")
    private String socialPayAddr;

    /**
     * 社保缴纳月份
     */
    @ExcelAttribute(name = "社保缴纳月份" )
    @Schema(description ="社保缴纳月份")
    @ExcelProperty("社保缴纳月份")
    private String socialPayMonth;

    /**
     * 社保生成月份
     */
    @ExcelAttribute(name = "社保生成月份" )
    @Schema(description ="社保生成月份")
    @ExcelProperty("社保生成月份")
    private String socialCreateMonth;

    /**
     * 锁定状态 0 未锁定 1 锁定
     */
    @ExcelAttribute(name = "锁定状态 0 未锁定 1 锁定" )
    @Schema(description ="锁定状态 0 未锁定 1 锁定")
    @ExcelProperty("锁定状态 0 未锁定 1 锁定")
    private String lockStatus;

    /**
     * 社保结算状态  0: 未结算  1: 待结算  2: 已结算
     */
    @ExcelAttribute(name = "社保结算状态  0: 未结算  1: 待结算  2: 已结算" )
    @Schema(description ="社保结算状态  0: 未结算  1: 待结算  2: 已结算")
    @ExcelProperty("社保结算状态  0: 未结算  1: 待结算  2: 已结算")
    private String socialSettlementFlag;

    /**
     * 公积金结算状态
     */
    @ExcelAttribute(name = "公积金结算状态" )
    @Schema(description ="公积金结算状态")
    @ExcelProperty("公积金结算状态")
    private String fundSettlementFlag;

    /**
     * 总合计
     */
    @ExcelAttribute(name = "总合计" )
    @Schema(description ="总合计")
    @ExcelProperty("总合计")
    private BigDecimal sumAll;

    /**
     * 公积金缴纳月份
     */
    @ExcelAttribute(name = "公积金缴纳月份" )
    @Schema(description ="公积金缴纳月份")
    @ExcelProperty("公积金缴纳月份")
    private String providentPayMonth;

    /**
     * 公积金生成月份
     */
    @ExcelAttribute(name = "公积金生成月份" )
    @Schema(description ="公积金生成月份")
    @ExcelProperty("公积金生成月份")
    private String providentCreateMonth;

    /**
     * 公积金户
     */
    @ExcelAttribute(name = "公积金户" )
    @Schema(description ="公积金户")
    @ExcelProperty("公积金户")
    private String providentHousehold;

    /**
     * 公积金缴纳地
     */
    @ExcelAttribute(name = "公积金缴纳地" )
    @Schema(description ="公积金缴纳地")
    @ExcelProperty("公积金缴纳地")
    private String providentPayAddr;

    /**
     * 公积金缴纳地-省
     */
    @ExcelAttribute(name = "公积金缴纳地-省" )
    @Schema(description ="公积金缴纳地-省")
    @ExcelProperty("公积金缴纳地-省")
    private String fundProvince;

    /**
     * 公积金缴纳地-市
     */
    @ExcelAttribute(name = "公积金缴纳地-市" )
    @Schema(description ="公积金缴纳地-市")
    @ExcelProperty("公积金缴纳地-市")
    private String fundCity;

    /**
     * 公积金缴纳地-县
     */
    @ExcelAttribute(name = "公积金缴纳地-县" )
    @Schema(description ="公积金缴纳地-县")
    @ExcelProperty("公积金缴纳地-县")
    private String fundTown;

    /**
     * 社保缴纳地-省
     */
    @ExcelAttribute(name = "社保缴纳地-省" )
    @Schema(description ="社保缴纳地-省")
    @ExcelProperty("社保缴纳地-省")
    private String socialProvince;

    /**
     * 社保缴纳地-市
     */
    @ExcelAttribute(name = "社保缴纳地-市" )
    @Schema(description ="社保缴纳地-市")
    @ExcelProperty("社保缴纳地-市")
    private String socialCity;

    /**
     * 社保缴纳地-县
     */
    @ExcelAttribute(name = "社保缴纳地-县" )
    @Schema(description ="社保缴纳地-县")
    @ExcelProperty("社保缴纳地-县")
    private String socialTown;

    /**
     * 社保ID
     */
    @ExcelAttribute(name = "社保ID" )
    @Schema(description ="社保ID")
    @ExcelProperty("社保ID")
    private String socialId;

    /**
     * 公积金ID
     */
    @ExcelAttribute(name = "公积金ID" )
    @Schema(description ="公积金ID")
    @ExcelProperty("公积金ID")
    private String fundId;

    /**
     * 社保合计
     */
    @ExcelAttribute(name = "社保合计" )
    @Schema(description ="社保合计")
    @ExcelProperty("社保合计")
    private BigDecimal socialSum;

    /**
     * 单位社保合计
     */
    @ExcelAttribute(name = "单位社保合计" )
    @Schema(description ="单位社保合计")
    @ExcelProperty("单位社保合计")
    private BigDecimal unitSocialSum;

    /**
     * 个人社保合计
     */
    @ExcelAttribute(name = "个人社保合计" )
    @Schema(description ="个人社保合计")
    @ExcelProperty("个人社保合计")
    private BigDecimal socialSecurityPersonalSum;

    /**
     * 公积金总合计
     */
    @ExcelAttribute(name = "公积金总合计" )
    @Schema(description ="公积金总合计")
    @ExcelProperty("公积金总合计")
    private BigDecimal providentSum;

    /**
     * 社保核准表ID
     */
    @ExcelAttribute(name = "社保核准表ID" )
    @Schema(description ="社保核准表ID")
    @ExcelProperty("社保核准表ID")
    private String socialSettlementId;

    /**
     * 公积金核准表ID
     */
    @ExcelAttribute(name = "公积金核准表ID" )
    @Schema(description ="公积金核准表ID")
    @ExcelProperty("公积金核准表ID")
    private String fundSettlementId;

    /**
     * 工资社保结算状态  0: 未结算  1:  已结算
     */
    @ExcelAttribute(name = "工资社保结算状态  0: 未结算  1:  已结算" )
    @Schema(description ="工资社保结算状态  0: 未结算  1:  已结算")
    @ExcelProperty("工资社保结算状态  0: 未结算  1:  已结算")
    private String salarySocialFlag;

    /**
     * 工资公积金结算状态  0: 未结算  1: 已结算
     */
    @ExcelAttribute(name = "工资公积金结算状态  0: 未结算  1: 已结算" )
    @Schema(description ="工资公积金结算状态  0: 未结算  1: 已结算")
    @ExcelProperty("工资公积金结算状态  0: 未结算  1: 已结算")
    private String salaryFundFlag;

    /**
     * 就职班组
     */
    @ExcelAttribute(name = "就职班组" )
    @Schema(description ="就职班组")
    @ExcelProperty("就职班组")
    private String inauguralTeam;

    /**
     * 电信编号
     */
    @ExcelAttribute(name = "电信编号" )
    @Schema(description ="电信编号")
    @ExcelProperty("电信编号")
    private String telecomNumber;

    /**
     * 排序字段
     */
    @ExcelAttribute(name = "排序字段" )
    @Schema(description ="排序字段")
    @ExcelProperty("排序字段")
    private String sortTime;

    /**
     * 代理结算id
     */
    @ExcelAttribute(name = "代理结算id" )
    @Schema(description ="代理结算id")
    @ExcelProperty("代理结算id")
    private String agentId;

    /**
     * 财务账单ID
     */
    @ExcelAttribute(name = "财务账单ID" )
    @Schema(description ="财务账单ID")
    @ExcelProperty("财务账单ID")
    private String financeBillId;

}
