/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 各个地市派单日期
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TDispatchDayConfVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id" )
	@ExcelProperty("id" )
	private String id;
	/**
	 * 省
	 */
	@NotBlank(message = "省 不能为空" )
	@Length(max = 32, message = "省 不能超过32 个字符" )
	@ExcelAttribute(name = "省", isNotEmpty = true, errorInfo = "省 不能为空", maxLength = 32)
	@Schema(description = "省" )
	@ExcelProperty("省" )
	private String province;
	/**
	 * 市
	 */
	@Length(max = 32, message = "市 不能超过32 个字符" )
	@ExcelAttribute(name = "市", maxLength = 32)
	@Schema(description = "市" )
	@ExcelProperty("市" )
	private String city;
	/**
	 * 县|区
	 */
	@Length(max = 32, message = "县|区 不能超过32 个字符" )
	@ExcelAttribute(name = "县|区", maxLength = 32)
	@Schema(description = "县|区" )
	@ExcelProperty("县|区" )
	private String town;
	/**
	 * 派单地名称
	 */
	@Length(max = 32, message = "派单地名称 不能超过32 个字符" )
	@ExcelAttribute(name = "派单地名称", maxLength = 32)
	@Schema(description = "派单地名称" )
	@ExcelProperty("派单地名称" )
	private String areaName;
	/**
	 * 派单日
	 */
	@ExcelAttribute(name = "派单日" )
	@Schema(description = "派单日" )
	@ExcelProperty("派单日" )
	private Integer day;

}
