/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TDispatchInfoVo extends RowIndex implements Serializable {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "ID" )
	@ExcelProperty("ID" )
	private String id;
	/**
	 * 员工ID
	 */
	@NotBlank(message = "员工ID 不能为空" )
	@Length(max = 32, message = "员工ID 不能超过32 个字符" )
	@ExcelAttribute(name = "员工ID", isNotEmpty = true, errorInfo = "员工ID 不能为空", maxLength = 32)
	@Schema(description = "员工ID" )
	@ExcelProperty("员工ID" )
	private String empId;
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50 个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名" )
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 员工编码
	 */
	@Length(max = 30, message = "员工编码 不能超过30 个字符" )
	@ExcelAttribute(name = "员工编码", maxLength = 30)
	@Schema(description = "员工编码" )
	@ExcelProperty("员工编码" )
	private String empNo;
	/**
	 * 员工身份证
	 */
	@Length(max = 20, message = "员工身份证 不能超过20 个字符" )
	@ExcelAttribute(name = "员工身份证", maxLength = 20)
	@Schema(description = "员工身份证" )
	@ExcelProperty("员工身份证" )
	private String empIdcard;
	/**
	 * 员工类型
	 */
	@Length(max = 32, message = "员工类型 不能超过32 个字符" )
	@ExcelAttribute(name = "员工类型", maxLength = 32)
	@Schema(description = "员工类型" )
	@ExcelProperty("员工类型" )
	private String empType;
	/**
	 * 员工电话
	 */
	@Length(max = 32, message = "员工电话 不能超过32 个字符" )
	@ExcelAttribute(name = "员工电话", maxLength = 32)
	@Schema(description = "员工电话" )
	@ExcelProperty("员工电话" )
	private String empMobile;
	/**
	 * 民族
	 */
	@Length(max = 32, message = "民族 不能超过32 个字符" )
	@ExcelAttribute(name = "民族", maxLength = 32)
	@Schema(description = "民族" )
	@ExcelProperty("民族" )
	private String empNational;
	/**
	 * 0未提交1待审核2审核通过3审核不通过4办理完成
	 */
	@NotBlank(message = "0未提交1待审核2审核通过3审核不通过4办理完成 不能为空" )
	@Length(max = 1, message = "0未提交1待审核2审核通过3审核不通过4办理完成 不能超过1 个字符" )
	@ExcelAttribute(name = "0未提交1待审核2审核通过3审核不通过4办理完成", isNotEmpty = true, errorInfo = "0未提交1待审核2审核通过3审核不通过4办理完成 不能为空", maxLength = 1)
	@Schema(description = "0未提交1待审核2审核通过3审核不通过4办理完成" )
	@ExcelProperty("0未提交1待审核2审核通过3审核不通过4办理完成" )
	private String status;
	/**
	 * 0派增1派减
	 */
	@NotBlank(message = "0派增1派减 不能为空" )
	@Length(max = 1, message = "0派增1派减 不能超过1 个字符" )
	@ExcelAttribute(name = "0派增1派减", isNotEmpty = true, errorInfo = "0派增1派减 不能为空", maxLength = 1)
	@Schema(description = "0派增1派减" )
	@ExcelProperty("0派增1派减" )
	private String type;
	/**
	 * 社保ID
	 */
	@Length(max = 32, message = "社保ID 不能超过32 个字符" )
	@ExcelAttribute(name = "社保ID", maxLength = 32)
	@Schema(description = "社保ID" )
	@ExcelProperty("社保ID" )
	private String socialId;
	/**
	 * 公积金ID
	 */
	@Length(max = 32, message = "公积金ID 不能超过32 个字符" )
	@ExcelAttribute(name = "公积金ID", maxLength = 32)
	@Schema(description = "公积金ID" )
	@ExcelProperty("公积金ID" )
	private String fundId;
	/**
	 * 0社保1公积金
	 */
	@Length(max = 1, message = "0社保1公积金 不能超过1 个字符" )
	@ExcelAttribute(name = "0社保1公积金", maxLength = 1)
	@Schema(description = "0社保1公积金" )
	@ExcelProperty("0社保1公积金" )
	private String typeSub;
	/**
	 * 流程实例ID
	 */
	@Length(max = 20, message = "流程实例ID 不能超过20 个字符" )
	@ExcelAttribute(name = "流程实例ID", maxLength = 20)
	@Schema(description = "流程实例ID" )
	@ExcelProperty("流程实例ID" )
	private String processInstId;
	/**
	 * 结算主体
	 */
	@Length(max = 32, message = "结算主体 不能超过32 个字符" )
	@ExcelAttribute(name = "结算主体", maxLength = 32)
	@Schema(description = "结算主体" )
	@ExcelProperty("结算主体" )
	private String settleDomain;
	/**
	 * 0未删除1删除
	 */
	@Length(max = 1, message = "0未删除1删除 不能超过1 个字符" )
	@ExcelAttribute(name = "0未删除1删除", maxLength = 1)
	@Schema(description = "0未删除1删除" )
	@ExcelProperty("0未删除1删除" )
	private String deleteFlag;
	/**
	 * 社保停缴日期
	 */
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期" )
	@ExcelProperty("社保停缴日期" )
	private Date socialReduceDate;
	/**
	 * 公积金停缴日期
	 */
	@ExcelAttribute(name = "公积金停缴日期", isDate = true)
	@Schema(description = "公积金停缴日期" )
	@ExcelProperty("公积金停缴日期" )
	private Date fundReduceDate;
	/**
	 * 离职日期
	 */
	@ExcelAttribute(name = "离职日期", isDate = true)
	@Schema(description = "离职日期" )
	@ExcelProperty("离职日期" )
	private Date leaveDate;
	/**
	 * 减少原因
	 */
	@Length(max = 32, message = "减少原因 不能超过32 个字符" )
	@ExcelAttribute(name = "减少原因", maxLength = 32)
	@Schema(description = "减少原因" )
	@ExcelProperty("减少原因" )
	private String reduceReason;
	/**
	 * 减少备注
	 */
	@Length(max = 200, message = "减少备注 不能超过200 个字符" )
	@ExcelAttribute(name = "减少备注", maxLength = 200)
	@Schema(description = "减少备注" )
	@ExcelProperty("减少备注" )
	private String reduceRemark;
	/**
	 * 所属单位
	 */
	@Length(max = 32, message = "所属单位 不能超过32 个字符" )
	@ExcelAttribute(name = "所属单位", maxLength = 32)
	@Schema(description = "所属单位" )
	@ExcelProperty("所属单位" )
	private String belongUnit;
	/**
	 * 当前操作人
	 */
	@Length(max = 32, message = "当前操作人 不能超过32 个字符" )
	@ExcelAttribute(name = "当前操作人", maxLength = 32)
	@Schema(description = "当前操作人" )
	@ExcelProperty("当前操作人" )
	private String currentOperator;
	/**
	 * 数据迁移使用
	 */
	@Length(max = 32, message = "数据迁移使用 不能超过32 个字符" )
	@ExcelAttribute(name = "数据迁移使用", maxLength = 32)
	@Schema(description = "数据迁移使用" )
	@ExcelProperty("数据迁移使用" )
	private String dispatchIdBak;
	/**
	 * 合同起始时间
	 */
	@ExcelAttribute(name = "合同起始时间", isDate = true)
	@Schema(description = "合同起始时间" )
	@ExcelProperty("合同起始时间" )
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "合同到期时间", isDate = true)
	@Schema(description = "合同到期时间" )
	@ExcelProperty("合同到期时间" )
	private Date contractEnd;
	/**
	 * 合同年限
	 */
	@ExcelAttribute(name = "合同年限" )
	@Schema(description = "合同年限" )
	@ExcelProperty("合同年限" )
	private Double contractTerm;
	/**
	 * 户口性质
	 */
	@Length(max = 32, message = "户口性质 不能超过32 个字符" )
	@ExcelAttribute(name = "户口性质", maxLength = 32)
	@Schema(description = "户口性质" )
	@ExcelProperty("户口性质" )
	private String empRegisType;
	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期", isDate = true)
	@Schema(description = "入职日期" )
	@ExcelProperty("入职日期" )
	private Date enjoinDate;
	/**
	 * 试用期（单位月）
	 */
	@Length(max = 32, message = "试用期（单位月） 不能超过32 个字符" )
	@ExcelAttribute(name = "试用期（单位月）", maxLength = 32)
	@Schema(description = "试用期（单位月）" )
	@ExcelProperty("试用期（单位月）" )
	private String tryPeriod;
	/**
	 * 档案所在地
	 */
	@Length(max = 50, message = "档案所在地 不能超过50 个字符" )
	@ExcelAttribute(name = "档案所在地", maxLength = 50)
	@Schema(description = "档案所在地" )
	@ExcelProperty("档案所在地" )
	private String fileAddr;
	/**
	 * 就职岗位
	 */
	@Length(max = 30, message = "就职岗位 不能超过30 个字符" )
	@ExcelAttribute(name = "就职岗位", maxLength = 30)
	@Schema(description = "就职岗位" )
	@ExcelProperty("就职岗位" )
	private String post;
	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100 个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@ExcelProperty("委托备注" )
	private String trustRemark;
	/**
	 * 档案-省
	 */
	@ExcelAttribute(name = "档案-省" )
	@Schema(description = "档案-省" )
	@ExcelProperty("档案-省" )
	private Integer fileProvince;
	/**
	 * 档案-市
	 */
	@ExcelAttribute(name = "档案-市" )
	@Schema(description = "档案-市" )
	@ExcelProperty("档案-市" )
	private Integer fileCity;
	/**
	 * 档案-县
	 */
	@ExcelAttribute(name = "档案-县" )
	@Schema(description = "档案-县" )
	@ExcelProperty("档案-县" )
	private Integer fileTown;
	/**
	 * 合同类型
	 */
	@Length(max = 32, message = "合同类型 不能超过32 个字符" )
	@ExcelAttribute(name = "合同类型", maxLength = 32)
	@Schema(description = "合同类型" )
	@ExcelProperty("合同类型" )
	private String contractType;
	/**
	 * 社保办理状态 0 未办理 1 全部办理成功(原-已办理) 2 全部办理失败（原-办理失败） 3已派减
	 */
	@Length(max = 1, message = "社保办理状态 0 未办理 1 全部办理成功(原-已办理) 2 全部办理失败（原-办理失败） 3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "社保办理状态 0 未办理 1 全部办理成功(原-已办理) 2 全部办理失败（原-办理失败） 3已派减", maxLength = 1)
	@Schema(description = "社保办理状态 0 未办理 1 全部办理成功(原-已办理) 2 全部办理失败（原-办理失败） 3已派减" )
	@ExcelProperty("社保办理状态 0 未办理 1 全部办理成功(原-已办理) 2 全部办理失败（原-办理失败） 3已派减" )
	private String socialHandleStatus;
	/**
	 * 公积金办理状态
	 */
	@Length(max = 1, message = "公积金办理状态 不能超过1 个字符" )
	@ExcelAttribute(name = "公积金办理状态", maxLength = 1)
	@Schema(description = "公积金办理状态" )
	@ExcelProperty("公积金办理状态" )
	private String fundHandleStatus;
	/**
	 * 当前流程环节的处理意见
	 */
	@Length(max = 200, message = "当前流程环节的处理意见 不能超过200 个字符" )
	@ExcelAttribute(name = "当前流程环节的处理意见", maxLength = 200)
	@Schema(description = "当前流程环节的处理意见" )
	@ExcelProperty("当前流程环节的处理意见" )
	private String handleRemark;
	/**
	 * 审核意见
	 */
	@Length(max = 255, message = "审核意见 不能超过255 个字符" )
	@ExcelAttribute(name = "审核意见", maxLength = 255)
	@Schema(description = "审核意见" )
	@ExcelProperty("审核意见" )
	private String auditRemark;
	/**
	 * 公积金办理备注
	 */
	@Length(max = 255, message = "公积金办理备注 不能超过255 个字符" )
	@ExcelAttribute(name = "公积金办理备注", maxLength = 255)
	@Schema(description = "公积金办理备注" )
	@ExcelProperty("公积金办理备注" )
	private String fundHandleRemark;
	/**
	 * 办理备注
	 */
	@Length(max = 255, message = "办理备注 不能超过255 个字符" )
	@ExcelAttribute(name = "办理备注", maxLength = 255)
	@Schema(description = "办理备注" )
	@ExcelProperty("办理备注" )
	private String socialHandleRemark;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@ExcelProperty("缴纳地-省" )
	private String socialProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 11, message = "缴纳地-市 不能超过11 个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 11)
	@Schema(description = "缴纳地-市" )
	@ExcelProperty("缴纳地-市" )
	private String socialCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@ExcelProperty("缴纳地-县" )
	private String socialTown;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@ExcelProperty("缴纳地-省" )
	private String fundProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市" )
	@ExcelProperty("缴纳地-市" )
	private String fundCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@ExcelProperty("缴纳地-县" )
	private String fundTown;
	/**
	 * 审核人
	 */
	@Length(max = 32, message = "审核人 不能超过32 个字符" )
	@ExcelAttribute(name = "审核人", maxLength = 32)
	@Schema(description = "审核人" )
	@ExcelProperty("审核人" )
	private String auditUser;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "审核时间", isDate = true)
	@Schema(description = "审核时间" )
	@ExcelProperty("审核时间" )
	private Date auditTime;
	/**
	 * 1标准工时 2 综合工时 3不定时工时制
	 */
	@Length(max = 1, message = "1标准工时 2 综合工时 3不定时工时制 不能超过1 个字符" )
	@ExcelAttribute(name = "1标准工时 2 综合工时 3不定时工时制", maxLength = 1)
	@Schema(description = "1标准工时 2 综合工时 3不定时工时制" )
	@ExcelProperty("1标准工时 2 综合工时 3不定时工时制" )
	private String workingHours;
	/**
	 * 申请人所在部门
	 */
	@Length(max = 50, message = "申请人所在部门 不能超过50 个字符" )
	@ExcelAttribute(name = "申请人所在部门", maxLength = 50)
	@Schema(description = "申请人所在部门" )
	@ExcelProperty("申请人所在部门" )
	private String organName;
	/**
	 * 派单项：如 养老、公积金
	 */
	@Length(max = 50, message = "派单项：如 养老、公积金 不能超过50 个字符" )
	@ExcelAttribute(name = "派单项：如 养老、公积金", maxLength = 50)
	@Schema(description = "派单项：如 养老、公积金" )
	@ExcelProperty("派单项：如 养老、公积金" )
	private String dispatchItem;
	/**
	 * settleDomainName
	 */
	@Length(max = 50, message = "settleDomainName 不能超过50 个字符" )
	@ExcelAttribute(name = "settleDomainName", maxLength = 50)
	@Schema(description = "settleDomainName" )
	@ExcelProperty("settleDomainName" )
	private String settleDomainName;
	/**
	 * 单位名称
	 */
	@Length(max = 50, message = "单位名称 不能超过50 个字符" )
	@ExcelAttribute(name = "单位名称", maxLength = 50)
	@Schema(description = "单位名称" )
	@ExcelProperty("单位名称" )
	private String belongUnitName;

}
