/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 派单信息记录表-批量派减
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TDispatchReduceVo extends RowIndex implements Serializable {

	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50 个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50, isNotEmpty = true)
	@Schema(description = "员工姓名" )
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 20, message = "身份证号 不能超过20 个字符" )
	@ExcelAttribute(name = "身份证号", maxLength = 20, isNotEmpty = true)
	@Schema(description = "身份证号" )
	@ExcelProperty("身份证号" )
	private String empIdcard;


	/**
	 * 社保停缴日期
	 */
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期：购买社保时必填" )
	@ExcelProperty("社保停缴日期" )
	private Date socialReduceDate;

	/**
	 * 公积金停缴日期
	 */
	@ExcelAttribute(name = "公积金停缴日期", isDate = true)
	@Schema(description = "公积金停缴日期" )
	@ExcelProperty("公积金停缴日期" )
	private Date fundReduceDate;

	/**
	 * 离职日期
	 */
	@ExcelAttribute(name = "离职日期", isDate = true)
	@Schema(description = "离职日期" )
	@ExcelProperty("离职日期" )
	private Date leaveDate;

	/**
	 * 减少原因
	 */
	@ExcelAttribute(name = "减少原因",isNotEmpty = true, isDataId = true,dataType = ExcelAttributeConstants.REDUCE_PROJECT_REASON)
	@Schema(description = "减少原因" )
	@ExcelProperty("减少原因" )
	private String reasonType;

	/**
	 * 委托备注
	 */
	@ExcelAttribute(name = "委托备注")
	@Schema(description = "委托备注" )
	@ExcelProperty("委托备注" )
	private String trustRemark;

}
