package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class TPreDispatchExportVo implements Serializable {

	/**
	 * 0 派增  1 派减
	 */
	@ExcelAttribute(name = "派单类型", maxLength = 2, isDataId = true,dataType = "send_order_type")
	@Schema(description ="派单类型:0 派增  1 派减")
	@ExcelProperty("派单类型")
	private String type;

	/**
	 * 日期，格式：2020-12-25
	 */
	@ExcelAttribute(name = "日期" )
	@Schema(description ="日期，格式：2020-12-25")
	@ExcelProperty("日期，格式：2020-12-25")
	private String date;

	/**
	 * 接单分公司
	 */
	@ExcelAttribute(name = "接单分公司" )
	@Schema(description ="接单分公司")
	@ExcelProperty("接单分公司")
	@Size(max = 50, message = "接单分公司不可超过50位")
	private String company;

	/**
	 * 缴费地
	 */
	@ExcelAttribute(name = "缴费地", isNotEmpty = true,errorInfo = "缴费地不能为空", maxLength = 20)
	@Schema(description ="缴费地")
	@ExcelProperty("缴费地")
	@NotNull(message = "缴费地不可为空")
	@Size(max = 20, message = "接单分公司不可超过20位")
	private String payAddress;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true,errorInfo = "身份证号不能为空", maxLength = 20, isIdCard = true)
	@Schema(description ="身份证号")
	@ExcelProperty("身份证号")
	@Size(max = 20, message = "客户名称不可超过20位")
	private String empIdcard;

	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", errorInfo = "客户名称不能为空", maxLength = 50)
	@Schema(description ="客户名称")
	@ExcelProperty("客户名称")
	@Size(max = 50, message = "客户名称不可超过50位")
	private String customerName;
	/**
	 * 员工姓名
	 */
	@ExcelProperty(value ="员工姓名")
	@ExcelAttribute(name = "员工姓名", needExport = true)
	private String empName;
	/**
	 * 联系电话1
	 */
	@ExcelProperty(value ="联系电话1")
	@ExcelAttribute(name = "联系电话1", needExport = true)
	private String telOne;
	/**
	 * 联系电话2
	 */
	@ExcelProperty(value ="联系电话2")
	@ExcelAttribute(name = "联系电话2", needExport = true)
	private String telTwo;
	/**
	 * 入职日期
	 */
	@ExcelProperty(value ="入职日期")
	@ExcelAttribute(name = "入职日期", needExport = true)
	private LocalDate entryDate;
	/**
	 * 正式工资
	 */
	@ExcelProperty(value ="正式工资")
	@ExcelAttribute(name = "正式工资", needExport = true)
	private String formalSalary;
	/**
	 * 派遣开始日期
	 */
	@ExcelProperty(value ="派遣开始日期")
	@ExcelAttribute(name = "派遣开始日期", needExport = true)
	private String dispatchStart;
	/**
	 * 派遣结束日期
	 */
	@ExcelProperty(value ="派遣结束日期")
	@ExcelAttribute(name = "派遣结束日期", needExport = true)
	private String dispatchEnd;
	/**
	 * 合同开始日期
	 */
	@ExcelProperty(value ="合同开始日期")
	@ExcelAttribute(name = "合同开始日期", needExport = true)
	private String contractStart;
	/**
	 * 合同终止日期
	 */
	@ExcelProperty(value ="合同终止日期")
	@ExcelAttribute(name = "合同终止日期", needExport = true)
	private String contractEnd;
	/**
	 * 试用开始日期
	 */
	@ExcelProperty(value ="试用开始日期")
	@ExcelAttribute(name = "试用开始日期", needExport = true)
	private String trialStart;
	/**
	 * 试用结束日期
	 */
	@ExcelProperty(value ="试用结束日期")
	@ExcelAttribute(name = "试用结束日期", needExport = true)
	private String trialEnd;
	/**
	 * 试用期工资
	 */
	@ExcelProperty(value ="试用期工资")
	@ExcelAttribute(name = "试用期工资", needExport = true)
	private String trialSalary;
	/**
	 * 工作制
	 */
	@ExcelProperty(value ="工作制")
	@ExcelAttribute(name = "工作制", needExport = true)
	private String workingSystem;
	/**
	 * 合同版本
	 */
	@ExcelProperty(value ="合同版本")
	@ExcelAttribute(name = "合同版本", needExport = true)
	private String contractVersion;
	/**
	 * 是否电话通知
	 */
	@ExcelProperty(value ="是否电话通知")
	@ExcelAttribute(name = "是否电话通知", needExport = true)
	private String telNotice;
	/**
	 * 实际工作地
	 */
	@ExcelProperty(value ="实际工作地")
	@ExcelAttribute(name = "实际工作地", needExport = true)
	private String workingAddress;
	/**
	 * 备注说明1
	 */
	@ExcelProperty(value ="备注说明1")
	@ExcelAttribute(name = "备注说明1", needExport = true)
	private String remarkOne;
	/**
	 * 备注说明2
	 */
	@ExcelProperty(value ="备注说明2")
	@ExcelAttribute(name = "备注说明2", needExport = true)
	private String remarkTwo;
	/**
	 * 养老城市
	 */
	@ExcelProperty(value ="养老城市")
	@ExcelAttribute(name = "养老城市", needExport = true)
	private String pensionAddress;
	/**
	 * 养老基数
	 */
	@ExcelProperty(value ="养老基数")
	@ExcelAttribute(name = "养老基数", needExport = true)
	private BigDecimal pensionBase;
	/**
	 * 养老起缴月
	 */
	@ExcelProperty(value ="养老起缴月")
	@ExcelAttribute(name = "养老起缴月", needExport = true)
	private String pensionStart;
	/**
	 * 医疗城市
	 */
	@ExcelProperty(value ="医疗城市")
	@ExcelAttribute(name = "医疗城市", needExport = true)
	private String medicalAddress;
	/**
	 * 医疗基数
	 */
	@ExcelProperty(value ="医疗基数")
	@ExcelAttribute(name = "医疗基数", needExport = true)
	private BigDecimal medicalBase;
	/**
	 * 医疗起缴月
	 */
	@ExcelProperty(value ="医疗起缴月")
	@ExcelAttribute(name = "医疗起缴月", needExport = true)
	private String medicalStart;
	/**
	 * 工伤城市
	 */
	@ExcelProperty(value ="工伤城市")
	@ExcelAttribute(name = "工伤城市", needExport = true)
	private String injuryAddress;
	/**
	 * 工伤基数
	 */
	@ExcelProperty(value ="工伤基数")
	@ExcelAttribute(name = "工伤基数", needExport = true)
	private BigDecimal injuryBase;
	/**
	 * 工伤起缴月
	 */
	@ExcelProperty(value ="工伤起缴月")
	@ExcelAttribute(name = "工伤起缴月", needExport = true)
	private String injuryStart;
	/**
	 * 生育城市
	 */
	@ExcelProperty(value ="生育城市")
	@ExcelAttribute(name = "生育城市", needExport = true)
	private String birthAddress;
	/**
	 * 生育基数
	 */
	@ExcelProperty(value ="生育基数")
	@ExcelAttribute(name = "生育基数", needExport = true)
	private BigDecimal birthBase;
	/**
	 * 生育起缴月
	 */
	@ExcelProperty(value ="生育起缴月")
	@ExcelAttribute(name = "生育起缴月", needExport = true)
	private String birthStart;
	/**
	 * 失业城市
	 */
	@ExcelProperty(value ="失业城市")
	@ExcelAttribute(name = "失业城市", needExport = true)
	private String unemploymentAddress;
	/**
	 * 失业基数
	 */
	@ExcelProperty(value ="失业基数")
	@ExcelAttribute(name = "失业基数", needExport = true)
	private BigDecimal unemploymentBase;
	/**
	 * 失业起缴月
	 */
	@ExcelProperty(value ="失业起缴月")
	@ExcelAttribute(name = "失业起缴月", needExport = true)
	private String unemploymentStart;
	/**
	 * 公积金城市
	 */
	@ExcelProperty(value ="公积金城市")
	@ExcelAttribute(name = "公积金城市", needExport = true)
	private String fundAddress;
	/**
	 * 公积金基数
	 */
	@ExcelProperty(value ="公积金基数")
	@ExcelAttribute(name = "公积金基数", needExport = true)
	private BigDecimal fundBase;
	/**
	 * 公积金起缴月
	 */
	@ExcelProperty(value ="公积金起缴月")
	@ExcelAttribute(name = "公积金起缴月", needExport = true)
	private String fundStart;
	/**
	 * 公积金个人比例
	 */
	@ExcelProperty(value ="公积金个人比例")
	@ExcelAttribute(name = "公积金个人比例", needExport = true)
	private BigDecimal fundPersonalPer;
	/**
	 * 公积金企业比例
	 */
	@ExcelProperty(value ="公积金企业比例")
	@ExcelAttribute(name = "公积金企业比例", needExport = true)
	private BigDecimal fundCompanyPer;
	/**
	 * 派单分公司
	 */
	@ExcelProperty(value ="派单分公司")
	@ExcelAttribute(name = "派单分公司", needExport = true)
	private String dispatchCompany;
	/**
	 * 派单客服
	 */
	@ExcelProperty(value ="派单客服")
	@ExcelAttribute(name = "派单客服", needExport = true)
	private String customerService;
	/**
	 * contract
	 */
	@ExcelProperty(value ="小合同名称")
	@ExcelAttribute(name = "小合同名称", needExport = true)
	private String contractMinorName;
	/**
	 * 唯一号
	 */
	@ExcelProperty(value ="唯一号")
	@ExcelAttribute(name = "唯一号", needExport = true)
	private String uniqueNumber;
	/**
	 * 客户编号
	 */
	@ExcelProperty(value ="客户编号")
	@ExcelAttribute(name = "客户编号", needExport = true)
	private String customerNumber;
	/**
	 * 服务类别
	 */
	@ExcelProperty(value ="服务类别")
	@ExcelAttribute(name = "服务类别", needExport = true)
	private String serviceType;
	/**
	 * 养老截止城市
	 */
	@ExcelProperty(value ="养老截止城市")
	@ExcelAttribute(name = "养老截止城市", needExport = true)
	private String pensionAddressReduce;
	/**
	 * 养老截止时间
	 */
	@ExcelProperty(value ="养老截止时间")
	@ExcelAttribute(name = "养老截止时间", needExport = true)
	private String pensionEndReduce;
	/**
	 * 医疗截止城市
	 */
	@ExcelProperty(value ="医疗截止城市")
	@ExcelAttribute(name = "医疗截止城市", needExport = true)
	private String medicalAddressReduce;
	/**
	 * 医疗截止时间
	 */
	@ExcelProperty(value ="医疗截止时间")
	@ExcelAttribute(name = "医疗截止时间", needExport = true)
	private String medicalEndReduce;
	/**
	 * 工伤截止城市
	 */
	@ExcelProperty(value ="工伤截止城市")
	@ExcelAttribute(name = "工伤截止城市", needExport = true)
	private String injuryAddressReduce;
	/**
	 * 工伤截止时间
	 */
	@ExcelProperty(value ="工伤截止时间")
	@ExcelAttribute(name = "工伤截止时间", needExport = true)
	private String injuryEndReduce;
	/**
	 * 生育截止城市
	 */
	@ExcelProperty(value ="生育截止城市")
	@ExcelAttribute(name = "生育截止城市", needExport = true)
	private String birthAddressReduce;
	/**
	 * 生育截止时间
	 */
	@ExcelProperty(value ="生育截止时间")
	@ExcelAttribute(name = "生育截止时间", needExport = true)
	private String birthEndReduce;
	/**
	 * 失业截止城市
	 */
	@ExcelProperty(value ="失业截止城市")
	@ExcelAttribute(name = "失业截止城市", needExport = true)
	private String unemploymentAddressReduce;
	/**
	 * 失业截止时间
	 */
	@ExcelProperty(value ="失业截止时间")
	@ExcelAttribute(name = "失业截止时间", needExport = true)
	private String unemploymentEndReduce;
	/**
	 * 公积金截止城市
	 */
	@ExcelProperty(value ="公积金截止城市")
	@ExcelAttribute(name = "公积金截止城市", needExport = true)
	private String fundAddressReduce;
	/**
	 * 公积金截止时间
	 */
	@ExcelProperty(value ="公积金截止时间")
	@ExcelAttribute(name = "公积金截止时间", needExport = true)
	private String fundEndReduce;
	/**
	 * 离职日期
	 */
	@ExcelProperty(value ="离职日期")
	@ExcelAttribute(name = "离职日期", needExport = true)
	private LocalDateTime leaveDate;
	/**
	 * 离职原因
	 */
	@ExcelProperty(value ="离职原因")
	@ExcelAttribute(name = "离职原因", needExport = true)
	private String leaveReason;
	/**
	 * 合同类型
	 */
	@ExcelProperty(value ="合同类型")
	@ExcelAttribute(name = "合同类型", needExport = true)
	private String contractType;
	/**
	 * 所属单位名称
	 */
	@ExcelProperty(value ="所属单位名称")
	@ExcelAttribute(name = "所属单位名称", needExport = true)
	private String unitNameAdd;
	/**
	 * 所属结算主体名称
	 */
	@ExcelProperty(value ="所属结算主体名称")
	@ExcelAttribute(name = "所属结算主体名称", needExport = true)
	private String departNameAdd;
	/**
	 * 备案基数
	 */
	@ExcelProperty(value ="备案基数")
	@ExcelAttribute(name = "备案基数", needExport = true)
	private BigDecimal filingBaseAdd;
	/**
	 * 0:正常未派单1:异常未派单2:已派单
	 */
	@ExcelProperty(value ="派单状态")
	@ExcelAttribute(name = "派单状态", needExport = true, readConverterExp = "0=正常未派单,1=异常未派单,2=已派单")
	private String preStatus;
	/**
	 * 0:正常1:作废
	 */
	@ExcelProperty(value ="预派单状态")
	@ExcelAttribute(name = "预派单状态", needExport = false)
	private String status;
	/**
	 * 异常内容
	 */
	@ExcelProperty(value ="异常内容")
	@ExcelAttribute(name = "异常内容", needExport = true)
	private String exceptionContent;
	/**
	 * 派单日期限制  在15日前可派单 15日及15后次月派单
	 */
	@ExcelProperty(value ="派单日期限制")
	@ExcelAttribute(name = "派单日期限制", needExport = true)
	private String dayLimit;
	/**
	 * 资料是否提交：0 是 1  否
	 */
	@ExcelProperty(value ="资料是否提交")
	@ExcelAttribute(name = "资料是否提交", needExport = true, readConverterExp = "0=是,1=否")
	private String dataSubStatus;

	/**
	 * 派单合同名称：合同名称删除后直接清空合同相关派单信息，主要增对已有合同存在的派单情况
	 */
	@ExcelProperty(value ="派单合同名称")
	@ExcelAttribute(name = "派单合同名称", maxLength = 50, needExport = true)
	private String contractNameAdd;

	/**
	 * 创建时间
	 */
	@ExcelProperty(value ="创建时间")
	@ExcelAttribute(name = "创建时间", needExport = true, isDate = true, dateFormatExport = LocalDateTimeUtils.DATE_TIME_PATTERN)
	private LocalDateTime createTime;

	/**
	 * 备注
	 */
	@ExcelProperty(value ="备注")
	@ExcelAttribute(name = "备注", needExport = true)
	private String remark;

	/**
	 * 是否派单：0 是 2 否
	 */
	@ExcelProperty(value ="是否派单")
	@ExcelAttribute(name = "是否派单", maxLength = 2, needExport = true, readConverterExp = "0=是,1=否")
	private String dispatchFlag;

	/**
	 * 取消原因：不派单时填写
	 */
	@ExcelProperty(value ="取消原因")
	@ExcelAttribute(name = "取消原因", maxLength = 255, needExport = true)
	private String cancelRemark;

}
