package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class TPreDispatchImportVo extends RowIndex implements Serializable {

	/**
	 * 日期，格式：2020-12-25
	 */
	@ExcelAttribute(name = "日期" )
	@Schema(description ="日期，格式：2020-12-25")
	@ExcelProperty("日期，格式：2020-12-25")
	private String date;

	/**
	 * 接单分公司
	 */
	@ExcelAttribute(name = "接单分公司" )
	@Schema(description ="接单分公司")
	@ExcelProperty("接单分公司")
	@Size(max = 50, message = "接单分公司不可超过50位")
	private String company;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true,errorInfo = "身份证号不能为空", maxLength = 20, isIdCard = true)
	@Schema(description ="身份证号")
	@ExcelProperty("身份证号")
	@Size(max = 20, message = "客户名称不可超过20位")
	private String empIdcard;

	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", errorInfo = "客户名称不能为空", maxLength = 50)
	@Schema(description ="客户名称")
	@ExcelProperty("客户名称")
	@Size(max = 50, message = "客户名称不可超过50位")
	private String customerName;
	/**
	 * 员工姓名
	 */
	@ExcelProperty(value ="员工姓名")
	@ExcelAttribute(name = "员工姓名", needExport = true)
	private String empName;
	/**
	 * 联系电话1
	 */
	@ExcelProperty(value ="联系电话1")
	@ExcelAttribute(name = "联系电话1", needExport = true)
	private String telOne;
	/**
	 * 联系电话2
	 */
	@ExcelProperty(value ="联系电话2")
	@ExcelAttribute(name = "联系电话2", needExport = true)
	private String telTwo;
	/**
	 * 入职日期
	 */
	@ExcelProperty(value ="入职日期")
	@ExcelAttribute(name = "入职日期", needExport = true)
	private LocalDate entryDate;
	/**
	 * 正式工资
	 */
	@ExcelProperty(value ="正式工资")
	@ExcelAttribute(name = "正式工资", needExport = true)
	private String formalSalary;
	/**
	 * 派遣开始日期
	 */
	@ExcelProperty(value ="派遣开始日期")
	@ExcelAttribute(name = "派遣开始日期", needExport = true)
	private String dispatchStart;
	/**
	 * 派遣结束日期
	 */
	@ExcelProperty(value ="派遣结束日期")
	@ExcelAttribute(name = "派遣结束日期", needExport = true)
	private String dispatchEnd;
	/**
	 * 合同开始日期
	 */
	@ExcelProperty(value ="合同开始日期")
	@ExcelAttribute(name = "合同开始日期", needExport = true)
	private String contractStart;
	/**
	 * 合同终止日期
	 */
	@ExcelProperty(value ="合同终止日期")
	@ExcelAttribute(name = "合同终止日期", needExport = true)
	private String contractEnd;
	/**
	 * 试用开始日期
	 */
	@ExcelProperty(value ="试用开始日期")
	@ExcelAttribute(name = "试用开始日期", needExport = true)
	private String trialStart;
	/**
	 * 试用结束日期
	 */
	@ExcelProperty(value ="试用结束日期")
	@ExcelAttribute(name = "试用结束日期", needExport = true)
	private String trialEnd;
	/**
	 * 试用期工资
	 */
	@ExcelProperty(value ="试用期工资")
	@ExcelAttribute(name = "试用期工资", needExport = true)
	private String trialSalary;
	/**
	 * 工作制
	 */
	@ExcelProperty(value ="工作制")
	@ExcelAttribute(name = "工作制", needExport = true)
	private String workingSystem;
	/**
	 * 合同版本
	 */
	@ExcelProperty(value ="合同版本")
	@ExcelAttribute(name = "合同版本", needExport = true)
	private String contractVersion;
	/**
	 * 是否电话通知
	 */
	@ExcelProperty(value ="是否电话通知")
	@ExcelAttribute(name = "是否电话通知", needExport = true)
	private String telNotice;
	/**
	 * 实际工作地
	 */
	@ExcelProperty(value ="实际工作地")
	@ExcelAttribute(name = "实际工作地", needExport = true)
	private String workingAddress;
	/**
	 * 备注说明1
	 */
	@ExcelProperty(value ="备注说明1")
	@ExcelAttribute(name = "备注说明1", needExport = true)
	private String remarkOne;
	/**
	 * 备注说明2
	 */
	@ExcelProperty(value ="备注说明2")
	@ExcelAttribute(name = "备注说明2", needExport = true)
	private String remarkTwo;
	/**
	 * 养老城市
	 */
	@ExcelProperty(value ="养老城市")
	@ExcelAttribute(name = "养老城市", needExport = true)
	private String pensionAddress;
	/**
	 * 养老基数
	 */
	@ExcelProperty(value ="养老基数")
	@ExcelAttribute(name = "养老基数", needExport = true)
	private BigDecimal pensionBase;
	/**
	 * 养老起缴月
	 */
	@ExcelProperty(value ="养老起缴月")
	@ExcelAttribute(name = "养老起缴月", needExport = true)
	private String pensionStart;
	/**
	 * 医疗城市
	 */
	@ExcelProperty(value ="医疗城市")
	@ExcelAttribute(name = "医疗城市", needExport = true)
	private String medicalAddress;
	/**
	 * 医疗基数
	 */
	@ExcelProperty(value ="医疗基数")
	@ExcelAttribute(name = "医疗基数", needExport = true)
	private BigDecimal medicalBase;
	/**
	 * 医疗起缴月
	 */
	@ExcelProperty(value ="医疗起缴月")
	@ExcelAttribute(name = "医疗起缴月", needExport = true)
	private String medicalStart;
	/**
	 * 工伤城市
	 */
	@ExcelProperty(value ="工伤城市")
	@ExcelAttribute(name = "工伤城市", needExport = true)
	private String injuryAddress;
	/**
	 * 工伤基数
	 */
	@ExcelProperty(value ="工伤基数")
	@ExcelAttribute(name = "工伤基数", needExport = true)
	private BigDecimal injuryBase;
	/**
	 * 工伤起缴月
	 */
	@ExcelProperty(value ="工伤起缴月")
	@ExcelAttribute(name = "工伤起缴月", needExport = true)
	private String injuryStart;
	/**
	 * 生育城市
	 */
	@ExcelProperty(value ="生育城市")
	@ExcelAttribute(name = "生育城市", needExport = true)
	private String birthAddress;
	/**
	 * 生育基数
	 */
	@ExcelProperty(value ="生育基数")
	@ExcelAttribute(name = "生育基数", needExport = true)
	private BigDecimal birthBase;
	/**
	 * 生育起缴月
	 */
	@ExcelProperty(value ="生育起缴月")
	@ExcelAttribute(name = "生育起缴月", needExport = true)
	private String birthStart;
	/**
	 * 失业城市
	 */
	@ExcelProperty(value ="失业城市")
	@ExcelAttribute(name = "失业城市", needExport = true)
	private String unemploymentAddress;
	/**
	 * 失业基数
	 */
	@ExcelProperty(value ="失业基数")
	@ExcelAttribute(name = "失业基数", needExport = true)
	private BigDecimal unemploymentBase;
	/**
	 * 失业起缴月
	 */
	@ExcelProperty(value ="失业起缴月")
	@ExcelAttribute(name = "失业起缴月", needExport = true)
	private String unemploymentStart;
	/**
	 * 公积金城市
	 */
	@ExcelProperty(value ="公积金城市")
	@ExcelAttribute(name = "公积金城市", needExport = true)
	private String fundAddress;
	/**
	 * 公积金基数
	 */
	@ExcelProperty(value ="公积金基数")
	@ExcelAttribute(name = "公积金基数", needExport = true)
	private BigDecimal fundBase;
	/**
	 * 公积金起缴月
	 */
	@ExcelProperty(value ="公积金起缴月")
	@ExcelAttribute(name = "公积金起缴月", needExport = true)
	private String fundStart;
	/**
	 * 公积金个人比例
	 */
	@ExcelProperty(value ="公积金个人比例")
	@ExcelAttribute(name = "公积金个人比例", needExport = true)
	private BigDecimal fundPersonalPer;
	/**
	 * 公积金企业比例
	 */
	@ExcelProperty(value ="公积金企业比例")
	@ExcelAttribute(name = "公积金企业比例", needExport = true)
	private BigDecimal fundCompanyPer;
	/**
	 * 派单分公司
	 */
	@ExcelProperty(value ="派单分公司")
	@ExcelAttribute(name = "派单分公司", needExport = true)
	private String dispatchCompany;
	/**
	 * 派单客服
	 */
	@ExcelProperty(value ="派单客服")
	@ExcelAttribute(name = "派单客服", needExport = true)
	private String customerService;
	/**
	 * contract
	 */
	@ExcelProperty(value ="小合同名称")
	@ExcelAttribute(name = "小合同名称", needExport = true)
	private String contractMinorName;
	/**
	 * 唯一号
	 */
	@ExcelProperty(value ="唯一号")
	@ExcelAttribute(name = "唯一号", needExport = true)
	private String uniqueNumber;
	/**
	 * 客户编号
	 */
	@ExcelProperty(value ="客户编号")
	@ExcelAttribute(name = "客户编号", needExport = true)
	private String customerNumber;
	/**
	 * 合同类型
	 */
	@ExcelProperty(value ="合同类型")
	@ExcelAttribute(name = "合同类型", needExport = true)
	private String contractType;
}
