/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 公积金信息
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TProvidentFundVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键" )
	@ExcelProperty("主键" )
	private String id;
	/**
	 * 公积金户
	 */
	@Length(max = 32, message = "公积金户 不能超过32 个字符" )
	@ExcelAttribute(name = "公积金户", maxLength = 32)
	@Schema(description = "公积金户" )
	@ExcelProperty("公积金户" )
	private String providentHousehold;
	/**
	 * 公积金起缴日期
	 */
	@ExcelAttribute(name = "公积金起缴日期", isDate = true)
	@Schema(description = "公积金起缴日期" )
	@ExcelProperty("公积金起缴日期" )
	private Date providentStart;
	/**
	 * 单位公积金缴纳基数
	 */
	@NotBlank(message = "单位公积金缴纳基数 不能为空" )
	@ExcelAttribute(name = "单位公积金缴纳基数", isNotEmpty = true, errorInfo = "单位公积金缴纳基数 不能为空" )
	@Schema(description = "单位公积金缴纳基数" )
	@ExcelProperty("单位公积金缴纳基数" )
	private BigDecimal unitProvidengCardinal;
	/**
	 * 个人公积金缴纳基数
	 */
	@NotBlank(message = "个人公积金缴纳基数 不能为空" )
	@ExcelAttribute(name = "个人公积金缴纳基数", isNotEmpty = true, errorInfo = "个人公积金缴纳基数 不能为空" )
	@Schema(description = "个人公积金缴纳基数" )
	@ExcelProperty("个人公积金缴纳基数" )
	private BigDecimal personalProvidentCardinal;
	/**
	 * 单位公积金缴纳比例
	 */
	@ExcelAttribute(name = "单位公积金缴纳比例" )
	@Schema(description = "单位公积金缴纳比例" )
	@ExcelProperty("单位公积金缴纳比例" )
	private BigDecimal unitProvidentPer;
	/**
	 * 个人公积金缴纳比例
	 */
	@ExcelAttribute(name = "个人公积金缴纳比例" )
	@Schema(description = "个人公积金缴纳比例" )
	@ExcelProperty("个人公积金缴纳比例" )
	private BigDecimal personalProvidentPer;
	/**
	 * 单位公积金缴纳费用
	 */
	@ExcelAttribute(name = "单位公积金缴纳费用" )
	@Schema(description = "单位公积金缴纳费用" )
	@ExcelProperty("单位公积金缴纳费用" )
	private BigDecimal unitProvidentFee;
	/**
	 * 个人公积金缴纳费用
	 */
	@ExcelAttribute(name = "个人公积金缴纳费用" )
	@Schema(description = "个人公积金缴纳费用" )
	@ExcelProperty("个人公积金缴纳费用" )
	private BigDecimal personalProvidentFee;
	/**
	 * 原ID（数据迁移）
	 */
	@Length(max = 11, message = "原ID（数据迁移） 不能超过11 个字符" )
	@ExcelAttribute(name = "原ID（数据迁移）", maxLength = 11)
	@Schema(description = "原ID（数据迁移）" )
	@ExcelProperty("原ID（数据迁移）" )
	private String oldId;
	/**
	 * 审核状态（0待审核/1已审核）
	 */
	@NotBlank(message = "审核状态（0待审核/1已审核） 不能为空" )
	@Length(max = 32, message = "审核状态（0待审核/1已审核） 不能超过32 个字符" )
	@ExcelAttribute(name = "审核状态（0待审核/1已审核）", isNotEmpty = true, errorInfo = "审核状态（0待审核/1已审核） 不能为空", maxLength = 32)
	@Schema(description = "审核状态（0待审核/1已审核）" )
	@ExcelProperty("审核状态（0待审核/1已审核）" )
	private String auditStatus;
	/**
	 * 办理状态（0待办理/1已办理）
	 */
	@NotBlank(message = "办理状态（0待办理/1已办理） 不能为空" )
	@Length(max = 32, message = "办理状态（0待办理/1已办理） 不能超过32 个字符" )
	@ExcelAttribute(name = "办理状态（0待办理/1已办理）", isNotEmpty = true, errorInfo = "办理状态（0待办理/1已办理） 不能为空", maxLength = 32)
	@Schema(description = "办理状态（0待办理/1已办理）" )
	@ExcelProperty("办理状态（0待办理/1已办理）" )
	private String handleStatus;
	/**
	 * 废弃状态（0正常/1已废弃）
	 */
	@Length(max = 1, message = "废弃状态（0正常/1已废弃） 不能超过1 个字符" )
	@ExcelAttribute(name = "废弃状态（0正常/1已废弃）", maxLength = 1)
	@Schema(description = "废弃状态（0正常/1已废弃）" )
	@ExcelProperty("废弃状态（0正常/1已废弃）" )
	private String draftStatus;
	/**
	 * 员工ID（数据引用）
	 */
	@Length(max = 32, message = "员工ID（数据引用） 不能超过32 个字符" )
	@ExcelAttribute(name = "员工ID（数据引用）", maxLength = 32)
	@Schema(description = "员工ID（数据引用）" )
	@ExcelProperty("员工ID（数据引用）" )
	private String empId;
	/**
	 * 员工编码
	 */
	@Length(max = 50, message = "员工编码 不能超过50 个字符" )
	@ExcelAttribute(name = "员工编码", maxLength = 50)
	@Schema(description = "员工编码" )
	@ExcelProperty("员工编码" )
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50 个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名" )
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 员工身份证
	 */
	@Length(max = 20, message = "员工身份证 不能超过20 个字符" )
	@ExcelAttribute(name = "员工身份证", maxLength = 20)
	@Schema(description = "员工身份证" )
	@ExcelProperty("员工身份证" )
	private String empIdcard;
	/**
	 * 结算主体
	 */
	@Length(max = 32, message = "结算主体 不能超过32 个字符" )
	@ExcelAttribute(name = "结算主体", maxLength = 32)
	@Schema(description = "结算主体" )
	@ExcelProperty("结算主体" )
	private String settleDomain;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@ExcelProperty("缴纳地-省" )
	private String fundProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市" )
	@ExcelProperty("缴纳地-市" )
	private String fundCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@ExcelProperty("缴纳地-县" )
	private String fundTown;
	/**
	 * 备注
	 */
	@Length(max = 255, message = "备注 不能超过255 个字符" )
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Schema(description = "备注" )
	@ExcelProperty("备注" )
	private String remark;
	/**
	 * 0为删除1删除
	 */
	@Length(max = 1, message = "0为删除1删除 不能超过1 个字符" )
	@ExcelAttribute(name = "0为删除1删除", maxLength = 1)
	@Schema(description = "0为删除1删除" )
	@ExcelProperty("0为删除1删除" )
	private String deleteFlag;
	/**
	 * 公积金配置ID
	 */
	@Length(max = 32, message = "公积金配置ID 不能超过32 个字符" )
	@ExcelAttribute(name = "公积金配置ID", maxLength = 32)
	@Schema(description = "公积金配置ID" )
	@ExcelProperty("公积金配置ID" )
	private String fundBaseSetId;
	/**
	 * 单边小数点 ，如：四舍五入、见角进元等
	 */
	@Length(max = 1, message = "单边小数点 ，如：四舍五入、见角进元等 不能超过1 个字符" )
	@ExcelAttribute(name = "单边小数点 ，如：四舍五入、见角进元等", maxLength = 1)
	@Schema(description = "单边小数点 ，如：四舍五入、见角进元等" )
	@ExcelProperty("单边小数点 ，如：四舍五入、见角进元等" )
	private String fundPayPoint;
	/**
	 * 流程实例ID
	 */
	@Length(max = 20, message = "流程实例ID 不能超过20 个字符" )
	@ExcelAttribute(name = "流程实例ID", maxLength = 20)
	@Schema(description = "流程实例ID" )
	@ExcelProperty("流程实例ID" )
	private String processInstId;
	/**
	 * 审核人
	 */
	@Length(max = 32, message = "审核人 不能超过32 个字符" )
	@ExcelAttribute(name = "审核人", maxLength = 32)
	@Schema(description = "审核人" )
	@ExcelProperty("审核人" )
	private String auditUser;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "审核时间", isDate = true)
	@Schema(description = "审核时间" )
	@ExcelProperty("审核时间" )
	private Date auditTime;
	/**
	 * 办理人
	 */
	@Length(max = 32, message = "办理人 不能超过32 个字符" )
	@ExcelAttribute(name = "办理人", maxLength = 32)
	@Schema(description = "办理人" )
	@ExcelProperty("办理人" )
	private String handleUser;
	/**
	 * 办理时间
	 */
	@ExcelAttribute(name = "办理时间", isDate = true)
	@Schema(description = "办理时间" )
	@ExcelProperty("办理时间" )
	private Date handleTime;
	/**
	 * 申请人
	 */
	@Length(max = 32, message = "申请人 不能超过32 个字符" )
	@ExcelAttribute(name = "申请人", maxLength = 32)
	@Schema(description = "申请人" )
	@ExcelProperty("申请人" )
	private String applyUser;
	/**
	 * 申请时间
	 */
	@ExcelAttribute(name = "申请时间", isDate = true)
	@Schema(description = "申请时间" )
	@ExcelProperty("申请时间" )
	private Date applyTime;
	/**
	 * 所属单位
	 */
	@Length(max = 32, message = "所属单位 不能超过32 个字符" )
	@ExcelAttribute(name = "所属单位", maxLength = 32)
	@Schema(description = "所属单位" )
	@ExcelProperty("所属单位" )
	private String belongUnit;
	/**
	 * 公积金停缴日期
	 */
	@ExcelAttribute(name = "公积金停缴日期", isDate = true)
	@Schema(description = "公积金停缴日期" )
	@ExcelProperty("公积金停缴日期" )
	private Date fundReduceDate;
	/**
	 * 是否可补缴 0：是，1：否
	 */
	@Length(max = 1, message = "是否可补缴 0：是，1：否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否可补缴 0：是，1：否", maxLength = 1)
	@Schema(description = "是否可补缴 0：是，1：否" )
	@ExcelProperty("是否可补缴 0：是，1：否" )
	private String canOverpay;
	/**
	 * 补缴期限
	 */
	@ExcelAttribute(name = "补缴期限" )
	@Schema(description = "补缴期限" )
	@ExcelProperty("补缴期限" )
	private Integer overpayNumber;
	/**
	 * 补缴是否采用最新基数0是1否
	 */
	@Length(max = 1, message = "补缴是否采用最新基数0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "补缴是否采用最新基数0是1否", maxLength = 1)
	@Schema(description = "补缴是否采用最新基数0是1否" )
	@ExcelProperty("补缴是否采用最新基数0是1否" )
	private String insuranceIsLatestCardinality;
	/**
	 * 是否含当月 0：是，1：否
	 */
	@Length(max = 1, message = "是否含当月 0：是，1：否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否含当月 0：是，1：否", maxLength = 1)
	@Schema(description = "是否含当月 0：是，1：否" )
	@ExcelProperty("是否含当月 0：是，1：否" )
	private String haveThisMonth;
	/**
	 * 派减办理人
	 */
	@Length(max = 32, message = "派减办理人 不能超过32 个字符" )
	@ExcelAttribute(name = "派减办理人", maxLength = 32)
	@Schema(description = "派减办理人" )
	@ExcelProperty("派减办理人" )
	private String reduceHandleUser;
	/**
	 * 派减办理时间
	 */
	@ExcelAttribute(name = "派减办理时间", isDate = true)
	@Schema(description = "派减办理时间" )
	@ExcelProperty("派减办理时间" )
	private Date reduceHandleTime;
	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100 个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@ExcelProperty("委托备注" )
	private String trustRemark;
	/**
	 * 是否可派减 0:是1：否
	 */
	@NotBlank(message = "是否可派减 0:是1：否 不能为空" )
	@Length(max = 1, message = "是否可派减 0:是1：否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否可派减 0:是1：否", isNotEmpty = true, errorInfo = "是否可派减 0:是1：否 不能为空", maxLength = 1)
	@Schema(description = "是否可派减 0:是1：否" )
	@ExcelProperty("是否可派减 0:是1：否" )
	private String reduceCan;
	/**
	 * 就职班组
	 */
	@Length(max = 50, message = "就职班组 不能超过50 个字符" )
	@ExcelAttribute(name = "就职班组", maxLength = 50)
	@Schema(description = "就职班组" )
	@ExcelProperty("就职班组" )
	private String inauguralTeam;
	/**
	 * 电信编号
	 */
	@Length(max = 50, message = "电信编号 不能超过50 个字符" )
	@ExcelAttribute(name = "电信编号", maxLength = 50)
	@Schema(description = "电信编号" )
	@ExcelProperty("电信编号" )
	private String telecomNumber;

}
