/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 社保公积金调基导出表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TSocialFundHistoryVo extends RowIndex implements Serializable {

	@ExcelProperty(value = "项目编码")
	private String deptNo;

	@Length(max = 20, message = "员工姓名 不能超过20 个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, maxLength = 20, needExport = true, errorInfo = "员工姓名必填且不可超过20位")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String empName;

	@Length(max = 20, message = "身份证号 不能超过20 个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 20, needExport = true, errorInfo = "身份证号必填且不可超过20位")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "缴纳类型", isNotEmpty = true, errorInfo = "缴纳类型必填", readConverterExp = "0=最低缴纳,1=自定义缴纳,2=最高缴纳")
	@Schema(description = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）")
	@ExcelProperty("缴纳类型")
	private String paymentType;

	@ExcelAttribute(name = "养老基数")
	@Schema(description = "养老基数")
	@ExcelProperty("养老基数")
	private BigDecimal unitPensionCardinal;

	@ExcelAttribute(name = "医疗基数")
	@Schema(description = "医疗基数")
	@ExcelProperty("医疗基数")
	private BigDecimal unitMedicalCardinal;

	@ExcelAttribute(name = "失业基数")
	@Schema(description = "失业基数")
	@ExcelProperty("失业基数")
	private BigDecimal unitUnemploymentCardinal;

	@ExcelAttribute(name = "工伤基数")
	@Schema(description = "工伤基数")
	@ExcelProperty("工伤基数")
	private BigDecimal unitWorkInjuryCardinal;

	@ExcelAttribute(name = "生育基数")
	@Schema(description = "生育基数")
	@ExcelProperty("生育基数")
	private BigDecimal unitBirthCardinal;

	@ExcelAttribute(name = "单位大病救助金额")
	@Schema(description = "单位大病救助金额")
	@ExcelProperty("单位大病救助金额")
	private BigDecimal unitBigailmentMoney;

	@ExcelAttribute(name = "个人大病救助金额")
	@Schema(description = "个人大病救助金额")
	@ExcelProperty("个人大病救助金额")
	private BigDecimal personalBigailmentMoney;

	@ExcelAttribute(name = "单位公积金基数")
	@Schema(description = "单位公积金基数")
	@ExcelProperty("单位公积金基数")
	private BigDecimal unitFundBase;

	@ExcelAttribute(name = "单位公积金比例")
	@Schema(description = "单位公积金比例")
	@ExcelProperty("单位公积金比例")
	private BigDecimal unitFundProp;

	@ExcelAttribute(name = "个人公积金基数")
	@Schema(description = "个人公积金基数")
	@ExcelProperty("个人公积金基数")
	private BigDecimal personalFundBase;

	@ExcelAttribute(name = "个人公积金比例")
	@Schema(description = "个人公积金比例")
	@ExcelProperty("个人公积金比例")
	private BigDecimal personalFundProp;

}
