/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 社保公积金查询表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TSocialFundInfoVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id" )
	@ExcelProperty("id" )
	private String id;
	/**
	 * 员工ID（数据引用）
	 */
	@Length(max = 32, message = "员工ID（数据引用） 不能超过32 个字符" )
	@ExcelAttribute(name = "员工ID（数据引用）", maxLength = 32)
	@Schema(description = "员工ID（数据引用）" )
	@ExcelProperty("员工ID（数据引用）" )
	private String empId;
	/**
	 * 员工编码
	 */
	@Length(max = 50, message = "员工编码 不能超过50 个字符" )
	@ExcelAttribute(name = "员工编码", maxLength = 50)
	@Schema(description = "员工编码" )
	@ExcelProperty("员工编码" )
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50 个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名" )
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 员工身份证
	 */
	@Length(max = 20, message = "员工身份证 不能超过20 个字符" )
	@ExcelAttribute(name = "员工身份证", maxLength = 20)
	@Schema(description = "员工身份证" )
	@ExcelProperty("员工身份证" )
	private String empIdcard;
	/**
	 * 员工类型
	 */
	@Length(max = 32, message = "员工类型 不能超过32 个字符" )
	@ExcelAttribute(name = "员工类型", maxLength = 32)
	@Schema(description = "员工类型" )
	@ExcelProperty("员工类型" )
	private String empType;
	/**
	 * 结算主体
	 */
	@Length(max = 32, message = "结算主体 不能超过32 个字符" )
	@ExcelAttribute(name = "结算主体", maxLength = 32)
	@Schema(description = "结算主体" )
	@ExcelProperty("结算主体" )
	private String settleDomain;
	/**
	 * 结算主体
	 */
	@Length(max = 50, message = "结算主体 不能超过50 个字符" )
	@ExcelAttribute(name = "结算主体", maxLength = 50)
	@Schema(description = "结算主体" )
	@ExcelProperty("结算主体" )
	private String settleDomainName;
	/**
	 * unitName
	 */
	@Length(max = 50, message = "unitName 不能超过50 个字符" )
	@ExcelAttribute(name = "unitName", maxLength = 50)
	@Schema(description = "unitName" )
	@ExcelProperty("unitName" )
	private String unitName;
	/**
	 * unitId
	 */
	@Length(max = 32, message = "unitId 不能超过32 个字符" )
	@ExcelAttribute(name = "unitId", maxLength = 32)
	@Schema(description = "unitId" )
	@ExcelProperty("unitId" )
	private String unitId;
	/**
	 * 社保户
	 */
	@Length(max = 32, message = "社保户 不能超过32 个字符" )
	@ExcelAttribute(name = "社保户", maxLength = 32)
	@Schema(description = "社保户" )
	@ExcelProperty("社保户" )
	private String socialHousehold;
	/**
	 * 社保户
	 */
	@Length(max = 50, message = "社保户 不能超过50 个字符" )
	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Schema(description = "社保户" )
	@ExcelProperty("社保户" )
	private String socialHouseholdName;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@ExcelProperty("缴纳地-省" )
	private String socialProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市" )
	@ExcelProperty("缴纳地-市" )
	private String socialCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@ExcelProperty("缴纳地-县" )
	private String socialTown;
	/**
	 * 公积金户
	 */
	@Length(max = 32, message = "公积金户 不能超过32 个字符" )
	@ExcelAttribute(name = "公积金户", maxLength = 32)
	@Schema(description = "公积金户" )
	@ExcelProperty("公积金户" )
	private String providentHousehold;
	/**
	 * 公积金户
	 */
	@Length(max = 50, message = "公积金户 不能超过50 个字符" )
	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Schema(description = "公积金户" )
	@ExcelProperty("公积金户" )
	private String providentHouseholdName;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@ExcelProperty("缴纳地-省" )
	private String fundProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市" )
	@ExcelProperty("缴纳地-市" )
	private String fundCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@ExcelProperty("缴纳地-县" )
	private String fundTown;
	/**
	 * 社保派增状态：待审核、待办理、办理成功、部分办理失败、办理失败
	 */
	@Length(max = 1, message = "社保派增状态：待审核、待办理、办理成功、部分办理失败、办理失败 不能超过1 个字符" )
	@ExcelAttribute(name = "社保派增状态：待审核、待办理、办理成功、部分办理失败、办理失败", maxLength = 1)
	@Schema(description = "社保派增状态：待审核、待办理、办理成功、部分办理失败、办理失败" )
	@ExcelProperty("社保派增状态：待审核、待办理、办理成功、部分办理失败、办理失败" )
	private String socialAddStatus;
	/**
	 * 公积金派增状态：待审核、待办理、办理成功、部分办理失败、办理失败
	 */
	@Length(max = 1, message = "公积金派增状态：待审核、待办理、办理成功、部分办理失败、办理失败 不能超过1 个字符" )
	@ExcelAttribute(name = "公积金派增状态：待审核、待办理、办理成功、部分办理失败、办理失败", maxLength = 1)
	@Schema(description = "公积金派增状态：待审核、待办理、办理成功、部分办理失败、办理失败" )
	@ExcelProperty("公积金派增状态：待审核、待办理、办理成功、部分办理失败、办理失败" )
	private String fundAddStatus;
	/**
	 * “待审核、待办理、办理成功、办理失败”
	 */
	@Length(max = 1, message = "“待审核、待办理、办理成功、办理失败” 不能超过1 个字符" )
	@ExcelAttribute(name = "“待审核、待办理、办理成功、办理失败”", maxLength = 1)
	@Schema(description = "“待审核、待办理、办理成功、办理失败”" )
	@ExcelProperty("“待审核、待办理、办理成功、办理失败”" )
	private String socialReduceStatus;
	/**
	 * “待审核、待办理、办理成功、办理失败”
	 */
	@Length(max = 1, message = "“待审核、待办理、办理成功、办理失败” 不能超过1 个字符" )
	@ExcelAttribute(name = "“待审核、待办理、办理成功、办理失败”", maxLength = 1)
	@Schema(description = "“待审核、待办理、办理成功、办理失败”" )
	@ExcelProperty("“待审核、待办理、办理成功、办理失败”" )
	private String fundReduceStatus;
	/**
	 * 社保ID(取值最新社保ID）
	 */
	@Length(max = 32, message = "社保ID(取值最新社保ID） 不能超过32 个字符" )
	@ExcelAttribute(name = "社保ID(取值最新社保ID）", maxLength = 32)
	@Schema(description = "社保ID(取值最新社保ID）" )
	@ExcelProperty("社保ID(取值最新社保ID）" )
	private String socialId;
	/**
	 * 公积金ID （取值最新公积金ID）
	 */
	@Length(max = 32, message = "公积金ID （取值最新公积金ID） 不能超过32 个字符" )
	@ExcelAttribute(name = "公积金ID （取值最新公积金ID）", maxLength = 32)
	@Schema(description = "公积金ID （取值最新公积金ID）" )
	@ExcelProperty("公积金ID （取值最新公积金ID）" )
	private String fundId;

	/**
	 * 首次购买时间（第一派单月份）
	 */
	@ExcelAttribute(name = "首次购买时间（第一派单月份）", isDate = true)
	@Schema(description = "首次购买时间（第一派单月份）" )
	@ExcelProperty("首次购买时间（第一派单月份）" )
	private Date firstBuyMonthSocial;
	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数" )
	@Schema(description = "单位养老基数" )
	@ExcelProperty("单位养老基数" )
	private BigDecimal unitPensionCardinal;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数" )
	@Schema(description = "单位医疗基数" )
	@ExcelProperty("单位医疗基数" )
	private BigDecimal unitMedicalCardinal;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数" )
	@Schema(description = "单位失业基数" )
	@ExcelProperty("单位失业基数" )
	private BigDecimal unitUnemploymentCardinal;
	/**
	 * 单位大病救助基数
	 */
	@ExcelAttribute(name = "单位大病救助基数" )
	@Schema(description = "单位大病救助基数" )
	@ExcelProperty("单位大病救助基数" )
	private BigDecimal unitBigailmentCardinal;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数" )
	@Schema(description = "单位工伤基数" )
	@ExcelProperty("单位工伤基数" )
	private BigDecimal unitWorkInjuryCardinal;
	/**
	 * 单位生育基数
	 */
	@ExcelAttribute(name = "单位生育基数" )
	@Schema(description = "单位生育基数" )
	@ExcelProperty("单位生育基数" )
	private BigDecimal unitBirthCardinal;
	/**
	 * 个人养老基数
	 */
	@ExcelAttribute(name = "个人养老基数" )
	@Schema(description = "个人养老基数" )
	@ExcelProperty("个人养老基数" )
	private BigDecimal personalPensionCardinal;
	/**
	 * 个人医疗基数
	 */
	@ExcelAttribute(name = "个人医疗基数" )
	@Schema(description = "个人医疗基数" )
	@ExcelProperty("个人医疗基数" )
	private BigDecimal personalMedicalCardinal;
	/**
	 * 个人大病救助基数
	 */
	@ExcelAttribute(name = "个人大病救助基数" )
	@Schema(description = "个人大病救助基数" )
	@ExcelProperty("个人大病救助基数" )
	private BigDecimal personalBigailmentCardinal;
	/**
	 * 个人失业基数
	 */
	@ExcelAttribute(name = "个人失业基数" )
	@Schema(description = "个人失业基数" )
	@ExcelProperty("个人失业基数" )
	private BigDecimal personalUnemploymentCardinal;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数" )
	@Schema(description = "单位工伤基数" )
	@ExcelProperty("单位工伤基数" )
	private BigDecimal personalWorkInjuryCardinal;
	/**
	 * 单位养老比例
	 */
	@ExcelAttribute(name = "单位养老比例" )
	@Schema(description = "单位养老比例" )
	@ExcelProperty("单位养老比例" )
	private BigDecimal unitPensionPer;
	/**
	 * 单位医疗比例
	 */
	@ExcelAttribute(name = "单位医疗比例" )
	@Schema(description = "单位医疗比例" )
	@ExcelProperty("单位医疗比例" )
	private BigDecimal unitMedicalPer;
	/**
	 * 单位失业比例
	 */
	@ExcelAttribute(name = "单位失业比例" )
	@Schema(description = "单位失业比例" )
	@ExcelProperty("单位失业比例" )
	private BigDecimal unitUnemploymentPer;
	/**
	 * 单位工伤比例
	 */
	@ExcelAttribute(name = "单位工伤比例" )
	@Schema(description = "单位工伤比例" )
	@ExcelProperty("单位工伤比例" )
	private BigDecimal unitWorkUnjuryPer;
	/**
	 * 单位生育比例
	 */
	@ExcelAttribute(name = "单位生育比例" )
	@Schema(description = "单位生育比例" )
	@ExcelProperty("单位生育比例" )
	private BigDecimal unitBirthPer;
	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例" )
	@Schema(description = "个人养老比例" )
	@ExcelProperty("个人养老比例" )
	private BigDecimal personalPensionPer;
	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例" )
	@Schema(description = "个人医疗比例" )
	@ExcelProperty("个人医疗比例" )
	private BigDecimal personalMedicalPer;
	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例" )
	@Schema(description = "个人失业比例" )
	@ExcelProperty("个人失业比例" )
	private BigDecimal personalUnemploymentPer;
	/**
	 * 办理状态
	 */
	@NotBlank(message = "办理状态 不能为空" )
	@Length(max = 32, message = "办理状态 不能超过32 个字符" )
	@ExcelAttribute(name = "办理状态", isNotEmpty = true, errorInfo = "办理状态 不能为空", maxLength = 32)
	@Schema(description = "办理状态" )
	@ExcelProperty("办理状态" )
	private String handleStatus;
	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例" )
	@Schema(description = "个人大病比例" )
	@ExcelProperty("个人大病比例" )
	private BigDecimal personalBigailmentPer;
	/**
	 * 单位大病救助比例
	 */
	@ExcelAttribute(name = "单位大病救助比例" )
	@Schema(description = "单位大病救助比例" )
	@ExcelProperty("单位大病救助比例" )
	private BigDecimal unitBigailmentPer;
	/**
	 * 社保停缴日期
	 */
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期" )
	@ExcelProperty("社保停缴日期" )
	private Date socialReduceDate;
	/**
	 * 是否可补缴 0：是，1：否
	 */
	@Length(max = 1, message = "是否可补缴 0：是，1：否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否可补缴 0：是，1：否", maxLength = 1)
	@Schema(description = "是否可补缴 0：是，1：否" )
	@ExcelProperty("是否可补缴 0：是，1：否" )
	private String canOverpay;
	/**
	 * 补缴政策（社保或公积金）
	 */
	@Length(max = 500, message = "补缴政策（社保或公积金） 不能超过500 个字符" )
	@ExcelAttribute(name = "补缴政策（社保或公积金）", maxLength = 500)
	@Schema(description = "补缴政策（社保或公积金）" )
	@ExcelProperty("补缴政策（社保或公积金）" )
	private String payPolicy;
	/**
	 * 补缴期限
	 */
	@ExcelAttribute(name = "补缴期限" )
	@Schema(description = "补缴期限" )
	@ExcelProperty("补缴期限" )
	private Integer overpayNumber;
	/**
	 * 是否含当月 0：是，1：否
	 */
	@Length(max = 1, message = "是否含当月 0：是，1：否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否含当月 0：是，1：否", maxLength = 1)
	@Schema(description = "是否含当月 0：是，1：否" )
	@ExcelProperty("是否含当月 0：是，1：否" )
	private String haveThisMonth;
	/**
	 * 是否能补缴养老0是1否
	 */
	@Length(max = 1, message = "是否能补缴养老0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴养老0是1否", maxLength = 1)
	@Schema(description = "是否能补缴养老0是1否" )
	@ExcelProperty("是否能补缴养老0是1否" )
	private String insurancePension;
	/**
	 * 是否能补缴医疗0是1否
	 */
	@Length(max = 1, message = "是否能补缴医疗0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴医疗0是1否", maxLength = 1)
	@Schema(description = "是否能补缴医疗0是1否" )
	@ExcelProperty("是否能补缴医疗0是1否" )
	private String insuranceMedical;
	/**
	 * 是否能补缴失业0是1否
	 */
	@Length(max = 1, message = "是否能补缴失业0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴失业0是1否", maxLength = 1)
	@Schema(description = "是否能补缴失业0是1否" )
	@ExcelProperty("是否能补缴失业0是1否" )
	private String insuranceUnemployment;
	/**
	 * 是否能补缴工伤0是1否
	 */
	@Length(max = 1, message = "是否能补缴工伤0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴工伤0是1否", maxLength = 1)
	@Schema(description = "是否能补缴工伤0是1否" )
	@ExcelProperty("是否能补缴工伤0是1否" )
	private String insuranceInjury;
	/**
	 * 是否能补缴生育0是1否
	 */
	@Length(max = 1, message = "是否能补缴生育0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴生育0是1否", maxLength = 1)
	@Schema(description = "是否能补缴生育0是1否" )
	@ExcelProperty("是否能补缴生育0是1否" )
	private String insuranceBirth;
	/**
	 * 是否能补缴大病0是1否
	 */
	@Length(max = 1, message = "是否能补缴大病0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴大病0是1否", maxLength = 1)
	@Schema(description = "是否能补缴大病0是1否" )
	@ExcelProperty("是否能补缴大病0是1否" )
	private String insuranceBigailment;
	/**
	 * 补缴是否采用最新基数0是1否
	 */
	@Length(max = 1, message = "补缴是否采用最新基数0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "补缴是否采用最新基数0是1否", maxLength = 1)
	@Schema(description = "补缴是否采用最新基数0是1否" )
	@ExcelProperty("补缴是否采用最新基数0是1否" )
	private String latestCardinality;
	/**
	 * 大病是否收费：0否 1 是
	 */
	@Length(max = 1, message = "大病是否收费：0否 1 是 不能超过1 个字符" )
	@ExcelAttribute(name = "大病是否收费：0否 1 是", maxLength = 1)
	@Schema(description = "大病是否收费：0否 1 是" )
	@ExcelProperty("大病是否收费：0否 1 是" )
	private String isIllness;
	/**
	 * 大病缴纳周期：0按年1按月
	 */
	@Length(max = 1, message = "大病缴纳周期：0按年1按月 不能超过1 个字符" )
	@ExcelAttribute(name = "大病缴纳周期：0按年1按月", maxLength = 1)
	@Schema(description = "大病缴纳周期：0按年1按月" )
	@ExcelProperty("大病缴纳周期：0按年1按月" )
	private String collectType;
	/**
	 * 大病取值方式0 按比例 1按定值
	 */
	@Length(max = 1, message = "大病取值方式0 按比例 1按定值 不能超过1 个字符" )
	@ExcelAttribute(name = "大病取值方式0 按比例 1按定值", maxLength = 1)
	@Schema(description = "大病取值方式0 按比例 1按定值" )
	@ExcelProperty("大病取值方式0 按比例 1按定值" )
	private String valueType;
	/**
	 * 大病按年收收取月份1-12月
	 */
	@ExcelAttribute(name = "大病按年收收取月份1-12月" )
	@Schema(description = "大病按年收收取月份1-12月" )
	@ExcelProperty("大病按年收收取月份1-12月" )
	private Integer collectMoth;
	/**
	 * 收费模式：0立即收，1次年收，对应旧值新员工入职收费：0是1否
	 */
	@Length(max = 1, message = "收费模式：0立即收，1次年收，对应旧值新员工入职收费：0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "收费模式：0立即收，1次年收，对应旧值新员工入职收费：0是1否", maxLength = 1)
	@Schema(description = "收费模式：0立即收，1次年收，对应旧值新员工入职收费：0是1否" )
	@ExcelProperty("收费模式：0立即收，1次年收，对应旧值新员工入职收费：0是1否" )
	private String isChargePersonal;
	/**
	 * 备案基数
	 */
	@Length(max = 255, message = "备案基数 不能超过255 个字符" )
	@ExcelAttribute(name = "备案基数", maxLength = 255)
	@Schema(description = "备案基数" )
	@ExcelProperty("备案基数" )
	private String recordBase;
	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100 个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@ExcelProperty("委托备注" )
	private String trustRemark;
	/**
	 * 缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）
	 */
	@Length(max = 1, message = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳） 不能超过1 个字符" )
	@ExcelAttribute(name = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）", maxLength = 1)
	@Schema(description = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）" )
	@ExcelProperty("缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）" )
	private String paymentType;
	/**
	 * 基数上限（社保或公积金）
	 */
	@ExcelAttribute(name = "基数上限（社保或公积金）" )
	@Schema(description = "基数上限（社保或公积金）" )
	@ExcelProperty("基数上限（社保或公积金）" )
	private BigDecimal upperLimit;
	/**
	 * 基数下限（社保或公积金）
	 */
	@ExcelAttribute(name = "基数下限（社保或公积金）" )
	@Schema(description = "基数下限（社保或公积金）" )
	@ExcelProperty("基数下限（社保或公积金）" )
	private BigDecimal lowerLimit;
	/**
	 * 养老起缴日期
	 */
	@ExcelAttribute(name = "养老起缴日期", isDate = true)
	@Schema(description = "养老起缴日期" )
	@ExcelProperty("养老起缴日期" )
	private Date pensionStart;
	/**
	 * 医疗起缴日期
	 */
	@ExcelAttribute(name = "医疗起缴日期", isDate = true)
	@Schema(description = "医疗起缴日期" )
	@ExcelProperty("医疗起缴日期" )
	private Date medicalStart;
	/**
	 * 失业起缴日期
	 */
	@ExcelAttribute(name = "失业起缴日期", isDate = true)
	@Schema(description = "失业起缴日期" )
	@ExcelProperty("失业起缴日期" )
	private Date unemployStart;
	/**
	 * 工伤起缴日期
	 */
	@ExcelAttribute(name = "工伤起缴日期", isDate = true)
	@Schema(description = "工伤起缴日期" )
	@ExcelProperty("工伤起缴日期" )
	private Date workInjuryStart;
	/**
	 * 生育起缴日期
	 */
	@ExcelAttribute(name = "生育起缴日期", isDate = true)
	@Schema(description = "生育起缴日期" )
	@ExcelProperty("生育起缴日期" )
	private Date birthStart;
	/**
	 * 大病起缴日期
	 */
	@ExcelAttribute(name = "大病起缴日期", isDate = true)
	@Schema(description = "大病起缴日期" )
	@ExcelProperty("大病起缴日期" )
	private Date bigailmentStart;
	/**
	 * 养老办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "养老办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "养老办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "养老办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("养老办理状态：0待办理1办理成功2办理失败3已派减" )
	private String pensionHandle;
	/**
	 * 医疗办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "医疗办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "医疗办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "医疗办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("医疗办理状态：0待办理1办理成功2办理失败3已派减" )
	private String medicalHandle;
	/**
	 * 失业办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "失业办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "失业办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "失业办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("失业办理状态：0待办理1办理成功2办理失败3已派减" )
	private String unemployHandle;
	/**
	 * 工伤办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "工伤办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "工伤办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "工伤办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("工伤办理状态：0待办理1办理成功2办理失败3已派减" )
	private String workInjuryHandle;
	/**
	 * 生育办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "生育办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "生育办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "生育办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("生育办理状态：0待办理1办理成功2办理失败3已派减" )
	private String birthHandle;
	/**
	 * 大病办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "大病办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "大病办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "大病办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("大病办理状态：0待办理1办理成功2办理失败3已派减" )
	private String bigailmentHandle;
	/**
	 * 单位养老金额
	 */
	@ExcelAttribute(name = "单位养老金额" )
	@Schema(description = "单位养老金额" )
	@ExcelProperty("单位养老金额" )
	private BigDecimal unitPersionMoney;
	/**
	 * 单位医疗金额
	 */
	@ExcelAttribute(name = "单位医疗金额" )
	@Schema(description = "单位医疗金额" )
	@ExcelProperty("单位医疗金额" )
	private BigDecimal unitMedicalMoney;
	/**
	 * 单位失业
	 */
	@ExcelAttribute(name = "单位失业" )
	@Schema(description = "单位失业" )
	@ExcelProperty("单位失业" )
	private BigDecimal unitUnemploymentMoney;
	/**
	 * 单位工伤金额
	 */
	@ExcelAttribute(name = "单位工伤金额" )
	@Schema(description = "单位工伤金额" )
	@ExcelProperty("单位工伤金额" )
	private BigDecimal unitInjuryMoney;
	/**
	 * 单位生育金额
	 */
	@ExcelAttribute(name = "单位生育金额" )
	@Schema(description = "单位生育金额" )
	@ExcelProperty("单位生育金额" )
	private BigDecimal unitBirthMoney;
	/**
	 * 单位大病救助金额
	 */
	@ExcelAttribute(name = "单位大病救助金额" )
	@Schema(description = "单位大病救助金额" )
	@ExcelProperty("单位大病救助金额" )
	private BigDecimal unitBigailmentMoney;
	/**
	 * 个人养老金额
	 */
	@ExcelAttribute(name = "个人养老金额" )
	@Schema(description = "个人养老金额" )
	@ExcelProperty("个人养老金额" )
	private BigDecimal personalPersionMoney;
	/**
	 * 个人医疗金额
	 */
	@ExcelAttribute(name = "个人医疗金额" )
	@Schema(description = "个人医疗金额" )
	@ExcelProperty("个人医疗金额" )
	private BigDecimal personalMedicalMoney;
	/**
	 * 个人失业金额
	 */
	@ExcelAttribute(name = "个人失业金额" )
	@Schema(description = "个人失业金额" )
	@ExcelProperty("个人失业金额" )
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额" )
	@Schema(description = "个人大病金额" )
	@ExcelProperty("个人大病金额" )
	private BigDecimal personalBigailmentMoney;
	/**
	 * 单位公积金缴纳基数
	 */
	@NotBlank(message = "单位公积金缴纳基数 不能为空" )
	@ExcelAttribute(name = "单位公积金缴纳基数", isNotEmpty = true, errorInfo = "单位公积金缴纳基数 不能为空" )
	@Schema(description = "单位公积金缴纳基数" )
	@ExcelProperty("单位公积金缴纳基数" )
	private BigDecimal unitProvidengCardinal;
	/**
	 * 个人公积金缴纳基数
	 */
	@NotBlank(message = "个人公积金缴纳基数 不能为空" )
	@ExcelAttribute(name = "个人公积金缴纳基数", isNotEmpty = true, errorInfo = "个人公积金缴纳基数 不能为空" )
	@Schema(description = "个人公积金缴纳基数" )
	@ExcelProperty("个人公积金缴纳基数" )
	private BigDecimal personalProvidentCardinal;
	/**
	 * 社保起缴日期
	 */
	@ExcelAttribute(name = "社保起缴日期", isDate = true)
	@Schema(description = "社保起缴日期" )
	@ExcelProperty("社保起缴日期" )
	private Date socialStartDate;
	/**
	 * 单位公积金缴纳比例
	 */
	@ExcelAttribute(name = "单位公积金缴纳比例" )
	@Schema(description = "单位公积金缴纳比例" )
	@ExcelProperty("单位公积金缴纳比例" )
	private BigDecimal unitProvidentPer;
	/**
	 * 个人公积金缴纳比例
	 */
	@ExcelAttribute(name = "个人公积金缴纳比例" )
	@Schema(description = "个人公积金缴纳比例" )
	@ExcelProperty("个人公积金缴纳比例" )
	private BigDecimal personalProvidentPer;
	/**
	 * 公积金起缴日期
	 */
	@ExcelAttribute(name = "公积金起缴日期", isDate = true)
	@Schema(description = "公积金起缴日期" )
	@ExcelProperty("公积金起缴日期" )
	private Date providentStart;
	/**
	 * 公积金初次购买月份
	 */
	@ExcelAttribute(name = "公积金初次购买月份", isDate = true)
	@Schema(description = "公积金初次购买月份" )
	@ExcelProperty("公积金初次购买月份" )
	private Date firstBuyMothFund;
	/**
	 * 基数上限（公积金）
	 */
	@ExcelAttribute(name = "基数上限（公积金）" )
	@Schema(description = "基数上限（公积金）" )
	@ExcelProperty("基数上限（公积金）" )
	private BigDecimal upperLimitFund;
	/**
	 * 基数下限（公积金）
	 */
	@ExcelAttribute(name = "基数下限（公积金）" )
	@Schema(description = "基数下限（公积金）" )
	@ExcelProperty("基数下限（公积金）" )
	private BigDecimal lowerLimitFund;
	/**
	 * 单边小数点 ，如：四舍五入、见角进元等
	 */
	@Length(max = 1, message = "单边小数点 ，如：四舍五入、见角进元等 不能超过1 个字符" )
	@ExcelAttribute(name = "单边小数点 ，如：四舍五入、见角进元等", maxLength = 1)
	@Schema(description = "单边小数点 ，如：四舍五入、见角进元等" )
	@ExcelProperty("单边小数点 ，如：四舍五入、见角进元等" )
	private String fundPayPoint;
	/**
	 * 是否可补缴 0：是，1：否(公积金)
	 */
	@Length(max = 1, message = "是否可补缴 0：是，1：否(公积金) 不能超过1 个字符" )
	@ExcelAttribute(name = "是否可补缴 0：是，1：否(公积金)", maxLength = 1)
	@Schema(description = "是否可补缴 0：是，1：否(公积金)" )
	@ExcelProperty("是否可补缴 0：是，1：否(公积金)" )
	private String canOverpayFund;
	/**
	 * 补缴期限(公积金)
	 */
	@ExcelAttribute(name = "补缴期限(公积金)" )
	@Schema(description = "补缴期限(公积金)" )
	@ExcelProperty("补缴期限(公积金)" )
	private Integer overpayNumberFund;
	/**
	 * 补缴政策（公积金）
	 */
	@Length(max = 500, message = "补缴政策（公积金） 不能超过500 个字符" )
	@ExcelAttribute(name = "补缴政策（公积金）", maxLength = 500)
	@Schema(description = "补缴政策（公积金）" )
	@ExcelProperty("补缴政策（公积金）" )
	private String payPolicyFund;
	/**
	 * 委托备注(公积金)
	 */
	@Length(max = 100, message = "委托备注(公积金) 不能超过100 个字符" )
	@ExcelAttribute(name = "委托备注(公积金)", maxLength = 100)
	@Schema(description = "委托备注(公积金)" )
	@ExcelProperty("委托备注(公积金)" )
	private String trustRemarkFund;
	/**
	 * 是否含当月 0：是，1：否(公积金)
	 */
	@Length(max = 1, message = "是否含当月 0：是，1：否(公积金) 不能超过1 个字符" )
	@ExcelAttribute(name = "是否含当月 0：是，1：否(公积金)", maxLength = 1)
	@Schema(description = "是否含当月 0：是，1：否(公积金)" )
	@ExcelProperty("是否含当月 0：是，1：否(公积金)" )
	private String haveThisMonthFund;
	/**
	 * 补缴是否采用最新基数0是1否(公积金)
	 */
	@Length(max = 1, message = "补缴是否采用最新基数0是1否(公积金) 不能超过1 个字符" )
	@ExcelAttribute(name = "补缴是否采用最新基数0是1否(公积金)", maxLength = 1)
	@Schema(description = "补缴是否采用最新基数0是1否(公积金)" )
	@ExcelProperty("补缴是否采用最新基数0是1否(公积金)" )
	private String latestCardinalityFund;

}
