/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 社保明细表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TSocialInfoVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键" )
	@ExcelProperty("主键" )
	private String id;
	/**
	 * 社保户
	 */
	@Length(max = 32, message = "社保户 不能超过32 个字符" )
	@ExcelAttribute(name = "社保户", maxLength = 32)
	@Schema(description = "社保户" )
	@ExcelProperty("社保户" )
	private String socialHousehold;
	/**
	 * 社保起缴日期
	 */
	@ExcelAttribute(name = "社保起缴日期", isDate = true)
	@Schema(description = "社保起缴日期" )
	@ExcelProperty("社保起缴日期" )
	private Date socialStartDate;
	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数" )
	@Schema(description = "单位养老基数" )
	@ExcelProperty("单位养老基数" )
	private BigDecimal unitPensionCardinal;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数" )
	@Schema(description = "单位医疗基数" )
	@ExcelProperty("单位医疗基数" )
	private BigDecimal unitMedicalCardinal;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数" )
	@Schema(description = "单位失业基数" )
	@ExcelProperty("单位失业基数" )
	private BigDecimal unitUnemploymentCardinal;
	/**
	 * 单位大病救助基数
	 */
	@ExcelAttribute(name = "单位大病救助基数" )
	@Schema(description = "单位大病救助基数" )
	@ExcelProperty("单位大病救助基数" )
	private BigDecimal unitBigailmentCardinal;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数" )
	@Schema(description = "单位工伤基数" )
	@ExcelProperty("单位工伤基数" )
	private BigDecimal unitWorkInjuryCardinal;
	/**
	 * 单位生育基数
	 */
	@ExcelAttribute(name = "单位生育基数" )
	@Schema(description = "单位生育基数" )
	@ExcelProperty("单位生育基数" )
	private BigDecimal unitBirthCardinal;
	/**
	 * 个人养老基数
	 */
	@ExcelAttribute(name = "个人养老基数" )
	@Schema(description = "个人养老基数" )
	@ExcelProperty("个人养老基数" )
	private BigDecimal personalPensionCardinal;
	/**
	 * 个人医疗基数
	 */
	@ExcelAttribute(name = "个人医疗基数" )
	@Schema(description = "个人医疗基数" )
	@ExcelProperty("个人医疗基数" )
	private BigDecimal personalMedicalCardinal;
	/**
	 * 个人大病救助基数
	 */
	@ExcelAttribute(name = "个人大病救助基数" )
	@Schema(description = "个人大病救助基数" )
	@ExcelProperty("个人大病救助基数" )
	private BigDecimal personalBigailmentCardinal;
	/**
	 * 个人失业基数
	 */
	@ExcelAttribute(name = "个人失业基数" )
	@Schema(description = "个人失业基数" )
	@ExcelProperty("个人失业基数" )
	private BigDecimal personalUnemploymentCardinal;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数" )
	@Schema(description = "单位工伤基数" )
	@ExcelProperty("单位工伤基数" )
	private BigDecimal personalWorkInjuryCardinal;
	/**
	 * 员工ID（数据引用）
	 */
	@Length(max = 32, message = "员工ID（数据引用） 不能超过32 个字符" )
	@ExcelAttribute(name = "员工ID（数据引用）", maxLength = 32)
	@Schema(description = "员工ID（数据引用）" )
	@ExcelProperty("员工ID（数据引用）" )
	private String empId;
	/**
	 * 员工编码
	 */
	@Length(max = 50, message = "员工编码 不能超过50 个字符" )
	@ExcelAttribute(name = "员工编码", maxLength = 50)
	@Schema(description = "员工编码" )
	@ExcelProperty("员工编码" )
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 50, message = "员工姓名 不能超过50 个字符" )
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名" )
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 员工身份证
	 */
	@Length(max = 20, message = "员工身份证 不能超过20 个字符" )
	@ExcelAttribute(name = "员工身份证", maxLength = 20)
	@Schema(description = "员工身份证" )
	@ExcelProperty("员工身份证" )
	private String empIdcard;
	/**
	 * 单位养老比例
	 */
	@ExcelAttribute(name = "单位养老比例" )
	@Schema(description = "单位养老比例" )
	@ExcelProperty("单位养老比例" )
	private BigDecimal unitPensionPer;
	/**
	 * 单位医疗比例
	 */
	@ExcelAttribute(name = "单位医疗比例" )
	@Schema(description = "单位医疗比例" )
	@ExcelProperty("单位医疗比例" )
	private BigDecimal unitMedicalPer;
	/**
	 * 单位失业比例
	 */
	@ExcelAttribute(name = "单位失业比例" )
	@Schema(description = "单位失业比例" )
	@ExcelProperty("单位失业比例" )
	private BigDecimal unitUnemploymentPer;
	/**
	 * 单位工伤比例
	 */
	@ExcelAttribute(name = "单位工伤比例" )
	@Schema(description = "单位工伤比例" )
	@ExcelProperty("单位工伤比例" )
	private BigDecimal unitWorkUnjuryPer;
	/**
	 * 单位生育比例
	 */
	@ExcelAttribute(name = "单位生育比例" )
	@Schema(description = "单位生育比例" )
	@ExcelProperty("单位生育比例" )
	private BigDecimal unitBirthPer;
	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例" )
	@Schema(description = "个人养老比例" )
	@ExcelProperty("个人养老比例" )
	private BigDecimal personalPensionPer;
	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例" )
	@Schema(description = "个人医疗比例" )
	@ExcelProperty("个人医疗比例" )
	private BigDecimal personalMedicalPer;
	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例" )
	@Schema(description = "个人失业比例" )
	@ExcelProperty("个人失业比例" )
	private BigDecimal personalUnemploymentPer;
	/**
	 * 审核状态
	 */
	@NotBlank(message = "审核状态 不能为空" )
	@Length(max = 32, message = "审核状态 不能超过32 个字符" )
	@ExcelAttribute(name = "审核状态", isNotEmpty = true, errorInfo = "审核状态 不能为空", maxLength = 32)
	@Schema(description = "审核状态" )
	@ExcelProperty("审核状态" )
	private String auditStatus;
	/**
	 * 办理状态
	 */
	@NotBlank(message = "办理状态 不能为空" )
	@Length(max = 32, message = "办理状态 不能超过32 个字符" )
	@ExcelAttribute(name = "办理状态", isNotEmpty = true, errorInfo = "办理状态 不能为空", maxLength = 32)
	@Schema(description = "办理状态" )
	@ExcelProperty("办理状态" )
	private String handleStatus;
	/**
	 * 草稿状态
	 */
	@NotBlank(message = "草稿状态 不能为空" )
	@Length(max = 1, message = "草稿状态 不能超过1 个字符" )
	@ExcelAttribute(name = "草稿状态", isNotEmpty = true, errorInfo = "草稿状态 不能为空", maxLength = 1)
	@Schema(description = "草稿状态" )
	@ExcelProperty("草稿状态" )
	private String draftStatus;
	/**
	 * 社保基数配置ID（数据引用）
	 */
	@Length(max = 32, message = "社保基数配置ID（数据引用） 不能超过32 个字符" )
	@ExcelAttribute(name = "社保基数配置ID（数据引用）", maxLength = 32)
	@Schema(description = "社保基数配置ID（数据引用）" )
	@ExcelProperty("社保基数配置ID（数据引用）" )
	private String cardinalIid;
	/**
	 * 原ID（数据迁移）
	 */
	@ExcelAttribute(name = "原ID（数据迁移）" )
	@Schema(description = "原ID（数据迁移）" )
	@ExcelProperty("原ID（数据迁移）" )
	private Integer oldId;
	/**
	 * 结算主体
	 */
	@Length(max = 32, message = "结算主体 不能超过32 个字符" )
	@ExcelAttribute(name = "结算主体", maxLength = 32)
	@Schema(description = "结算主体" )
	@ExcelProperty("结算主体" )
	private String settleDomain;
	/**
	 * 缴纳地-省
	 */
	@Length(max = 32, message = "缴纳地-省 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-省", maxLength = 32)
	@Schema(description = "缴纳地-省" )
	@ExcelProperty("缴纳地-省" )
	private String socialProvince;
	/**
	 * 缴纳地-市
	 */
	@Length(max = 32, message = "缴纳地-市 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-市", maxLength = 32)
	@Schema(description = "缴纳地-市" )
	@ExcelProperty("缴纳地-市" )
	private String socialCity;
	/**
	 * 缴纳地-县
	 */
	@Length(max = 32, message = "缴纳地-县 不能超过32 个字符" )
	@ExcelAttribute(name = "缴纳地-县", maxLength = 32)
	@Schema(description = "缴纳地-县" )
	@ExcelProperty("缴纳地-县" )
	private String socialTown;
	/**
	 * 备注
	 */
	@Length(max = 255, message = "备注 不能超过255 个字符" )
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Schema(description = "备注" )
	@ExcelProperty("备注" )
	private String remark;
	/**
	 * 0为删除1删除
	 */
	@Length(max = 1, message = "0为删除1删除 不能超过1 个字符" )
	@ExcelAttribute(name = "0为删除1删除", maxLength = 1)
	@Schema(description = "0为删除1删除" )
	@ExcelProperty("0为删除1删除" )
	private String deleteFlag;
	/**
	 * 单位养老金额
	 */
	@ExcelAttribute(name = "单位养老金额" )
	@Schema(description = "单位养老金额" )
	@ExcelProperty("单位养老金额" )
	private BigDecimal unitPersionMoney;
	/**
	 * 单位医疗金额
	 */
	@ExcelAttribute(name = "单位医疗金额" )
	@Schema(description = "单位医疗金额" )
	@ExcelProperty("单位医疗金额" )
	private BigDecimal unitMedicalMoney;
	/**
	 * 单位失业
	 */
	@ExcelAttribute(name = "单位失业" )
	@Schema(description = "单位失业" )
	@ExcelProperty("单位失业" )
	private BigDecimal unitUnemploymentMoney;
	/**
	 * 单位工伤金额
	 */
	@ExcelAttribute(name = "单位工伤金额" )
	@Schema(description = "单位工伤金额" )
	@ExcelProperty("单位工伤金额" )
	private BigDecimal unitInjuryMoney;
	/**
	 * 单位生育金额
	 */
	@ExcelAttribute(name = "单位生育金额" )
	@Schema(description = "单位生育金额" )
	@ExcelProperty("单位生育金额" )
	private BigDecimal unitBirthMoney;
	/**
	 * 单位大病救助金额
	 */
	@ExcelAttribute(name = "单位大病救助金额" )
	@Schema(description = "单位大病救助金额" )
	@ExcelProperty("单位大病救助金额" )
	private BigDecimal unitBigailmentMoney;
	/**
	 * 个人养老金额
	 */
	@ExcelAttribute(name = "个人养老金额" )
	@Schema(description = "个人养老金额" )
	@ExcelProperty("个人养老金额" )
	private BigDecimal personalPersionMoney;
	/**
	 * 个人医疗金额
	 */
	@ExcelAttribute(name = "个人医疗金额" )
	@Schema(description = "个人医疗金额" )
	@ExcelProperty("个人医疗金额" )
	private BigDecimal personalMedicalMoney;
	/**
	 * 个人失业金额
	 */
	@ExcelAttribute(name = "个人失业金额" )
	@Schema(description = "个人失业金额" )
	@ExcelProperty("个人失业金额" )
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额" )
	@Schema(description = "个人大病金额" )
	@ExcelProperty("个人大病金额" )
	private BigDecimal personalBigailmentMoney;
	/**
	 * 大病取值方式0 按比例 1按定值
	 */
	@Length(max = 1, message = "大病取值方式0 按比例 1按定值 不能超过1 个字符" )
	@ExcelAttribute(name = "大病取值方式0 按比例 1按定值", maxLength = 1)
	@Schema(description = "大病取值方式0 按比例 1按定值" )
	@ExcelProperty("大病取值方式0 按比例 1按定值" )
	private String valueType;
	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例" )
	@Schema(description = "个人大病比例" )
	@ExcelProperty("个人大病比例" )
	private BigDecimal personalBigailmentPer;
	/**
	 * 单位大病救助比例
	 */
	@ExcelAttribute(name = "单位大病救助比例" )
	@Schema(description = "单位大病救助比例" )
	@ExcelProperty("单位大病救助比例" )
	private BigDecimal unitBigailmentPer;
	/**
	 * 是否收取大病费用0否 1 是
	 */
	@Length(max = 1, message = "是否收取大病费用0否 1 是 不能超过1 个字符" )
	@ExcelAttribute(name = "是否收取大病费用0否 1 是", maxLength = 1)
	@Schema(description = "是否收取大病费用0否 1 是" )
	@ExcelProperty("是否收取大病费用0否 1 是" )
	private String isIllness;
	/**
	 * 大病按年收收取月份1-12月
	 */
	@ExcelAttribute(name = "大病按年收收取月份1-12月" )
	@Schema(description = "大病按年收收取月份1-12月" )
	@ExcelProperty("大病按年收收取月份1-12月" )
	private Integer collectMoth;
	/**
	 * 0按年1按月
	 */
	@Length(max = 1, message = "0按年1按月 不能超过1 个字符" )
	@ExcelAttribute(name = "0按年1按月", maxLength = 1)
	@Schema(description = "0按年1按月" )
	@ExcelProperty("0按年1按月" )
	private String collectType;
	/**
	 * 流程实例ID
	 */
	@Length(max = 20, message = "流程实例ID 不能超过20 个字符" )
	@ExcelAttribute(name = "流程实例ID", maxLength = 20)
	@Schema(description = "流程实例ID" )
	@ExcelProperty("流程实例ID" )
	private String processInstId;
	/**
	 * 审核人
	 */
	@Length(max = 32, message = "审核人 不能超过32 个字符" )
	@ExcelAttribute(name = "审核人", maxLength = 32)
	@Schema(description = "审核人" )
	@ExcelProperty("审核人" )
	private String auditUser;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "审核时间", isDate = true)
	@Schema(description = "审核时间" )
	@ExcelProperty("审核时间" )
	private Date auditTime;
	/**
	 * 办理人
	 */
	@Length(max = 32, message = "办理人 不能超过32 个字符" )
	@ExcelAttribute(name = "办理人", maxLength = 32)
	@Schema(description = "办理人" )
	@ExcelProperty("办理人" )
	private String handleUser;
	/**
	 * 办理时间
	 */
	@ExcelAttribute(name = "办理时间", isDate = true)
	@Schema(description = "办理时间" )
	@ExcelProperty("办理时间" )
	private Date handleTime;
	/**
	 * 所属单位
	 */
	@Length(max = 32, message = "所属单位 不能超过32 个字符" )
	@ExcelAttribute(name = "所属单位", maxLength = 32)
	@Schema(description = "所属单位" )
	@ExcelProperty("所属单位" )
	private String belongUnit;
	/**
	 * 社保停缴日期
	 */
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期" )
	@ExcelProperty("社保停缴日期" )
	private Date socialReduceDate;
	/**
	 * 是否可补缴 0：是，1：否
	 */
	@Length(max = 1, message = "是否可补缴 0：是，1：否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否可补缴 0：是，1：否", maxLength = 1)
	@Schema(description = "是否可补缴 0：是，1：否" )
	@ExcelProperty("是否可补缴 0：是，1：否" )
	private String canOverpay;
	/**
	 * 补缴期限
	 */
	@ExcelAttribute(name = "补缴期限" )
	@Schema(description = "补缴期限" )
	@ExcelProperty("补缴期限" )
	private Integer overpayNumber;
	/**
	 * 是否含当月 0：是，1：否
	 */
	@Length(max = 1, message = "是否含当月 0：是，1：否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否含当月 0：是，1：否", maxLength = 1)
	@Schema(description = "是否含当月 0：是，1：否" )
	@ExcelProperty("是否含当月 0：是，1：否" )
	private String haveThisMonth;
	/**
	 * 是否能补缴养老0是1否
	 */
	@Length(max = 1, message = "是否能补缴养老0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴养老0是1否", maxLength = 1)
	@Schema(description = "是否能补缴养老0是1否" )
	@ExcelProperty("是否能补缴养老0是1否" )
	private String insurancePension;
	/**
	 * 是否能补缴医疗0是1否
	 */
	@Length(max = 1, message = "是否能补缴医疗0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴医疗0是1否", maxLength = 1)
	@Schema(description = "是否能补缴医疗0是1否" )
	@ExcelProperty("是否能补缴医疗0是1否" )
	private String insuranceMedical;
	/**
	 * 是否能补缴失业0是1否
	 */
	@Length(max = 1, message = "是否能补缴失业0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴失业0是1否", maxLength = 1)
	@Schema(description = "是否能补缴失业0是1否" )
	@ExcelProperty("是否能补缴失业0是1否" )
	private String insuranceUnemployment;
	/**
	 * 是否能补缴工伤0是1否
	 */
	@Length(max = 1, message = "是否能补缴工伤0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴工伤0是1否", maxLength = 1)
	@Schema(description = "是否能补缴工伤0是1否" )
	@ExcelProperty("是否能补缴工伤0是1否" )
	private String insuranceInjury;
	/**
	 * 是否能补缴生育0是1否
	 */
	@Length(max = 1, message = "是否能补缴生育0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴生育0是1否", maxLength = 1)
	@Schema(description = "是否能补缴生育0是1否" )
	@ExcelProperty("是否能补缴生育0是1否" )
	private String insuranceBirth;
	/**
	 * 是否能补缴大病0是1否
	 */
	@Length(max = 1, message = "是否能补缴大病0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否能补缴大病0是1否", maxLength = 1)
	@Schema(description = "是否能补缴大病0是1否" )
	@ExcelProperty("是否能补缴大病0是1否" )
	private String insuranceBigailment;
	/**
	 * 补缴是否采用最新基数0是1否
	 */
	@Length(max = 1, message = "补缴是否采用最新基数0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "补缴是否采用最新基数0是1否", maxLength = 1)
	@Schema(description = "补缴是否采用最新基数0是1否" )
	@ExcelProperty("补缴是否采用最新基数0是1否" )
	private String insuranceIsLatestCardinality;
	/**
	 * 派减办理人
	 */
	@Length(max = 32, message = "派减办理人 不能超过32 个字符" )
	@ExcelAttribute(name = "派减办理人", maxLength = 32)
	@Schema(description = "派减办理人" )
	@ExcelProperty("派减办理人" )
	private String reduceHandleUser;
	/**
	 * 派减办理时间
	 */
	@ExcelAttribute(name = "派减办理时间", isDate = true)
	@Schema(description = "派减办理时间" )
	@ExcelProperty("派减办理时间" )
	private Date reduceHandleTime;
	/**
	 * 新员工入职收费：0是1否
	 */
	@Length(max = 1, message = "新员工入职收费：0是1否 不能超过1 个字符" )
	@ExcelAttribute(name = "新员工入职收费：0是1否", maxLength = 1)
	@Schema(description = "新员工入职收费：0是1否" )
	@ExcelProperty("新员工入职收费：0是1否" )
	private String isChargePersonal;
	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100 个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@ExcelProperty("委托备注" )
	private String trustRemark;
	/**
	 * 是否可派减 0:是1：否
	 */
	@NotBlank(message = "是否可派减 0:是1：否 不能为空" )
	@Length(max = 1, message = "是否可派减 0:是1：否 不能超过1 个字符" )
	@ExcelAttribute(name = "是否可派减 0:是1：否", isNotEmpty = true, errorInfo = "是否可派减 0:是1：否 不能为空", maxLength = 1)
	@Schema(description = "是否可派减 0:是1：否" )
	@ExcelProperty("是否可派减 0:是1：否" )
	private String reduceCan;
	/**
	 * 就职班组
	 */
	@Length(max = 50, message = "就职班组 不能超过50 个字符" )
	@ExcelAttribute(name = "就职班组", maxLength = 50)
	@Schema(description = "就职班组" )
	@ExcelProperty("就职班组" )
	private String inauguralTeam;
	/**
	 * 电信编号
	 */
	@Length(max = 50, message = "电信编号 不能超过50 个字符" )
	@ExcelAttribute(name = "电信编号", maxLength = 50)
	@Schema(description = "电信编号" )
	@ExcelProperty("电信编号" )
	private String telecomNumber;
	/**
	 * 缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）
	 */
	@Length(max = 1, message = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳） 不能超过1 个字符" )
	@ExcelAttribute(name = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）", maxLength = 1)
	@Schema(description = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）" )
	@ExcelProperty("缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）" )
	private String paymentType;
	/**
	 * 备案基数
	 */
	@Length(max = 255, message = "备案基数 不能超过255 个字符" )
	@ExcelAttribute(name = "备案基数", maxLength = 255)
	@Schema(description = "备案基数" )
	@ExcelProperty("备案基数" )
	private String recordBase;
	/**
	 * 社保类型区分（0五险、1单独兼职工伤）
	 */
	@ExcelAttribute(name = "社保类型区分（0五险、1单独兼职工伤）" )
	@Schema(description = "社保类型区分（0五险、1单独兼职工伤）" )
	@ExcelProperty("社保类型区分（0五险、1单独兼职工伤）" )
	private Integer socialType;
	/**
	 * 0不随配置 1随配置 2.单位大病随配置 3个人大病随配置
	 */
	@Length(max = 1, message = "0不随配置 1随配置 2.单位大病随配置 3个人大病随配置 不能超过1 个字符" )
	@ExcelAttribute(name = "0不随配置 1随配置 2.单位大病随配置 3个人大病随配置", maxLength = 1)
	@Schema(description = "0不随配置 1随配置 2.单位大病随配置 3个人大病随配置" )
	@ExcelProperty("0不随配置 1随配置 2.单位大病随配置 3个人大病随配置" )
	private String bigailmentVaryFlag;
	/**
	 * 养老起缴日期
	 */
	@ExcelAttribute(name = "养老起缴日期", isDate = true)
	@Schema(description = "养老起缴日期" )
	@ExcelProperty("养老起缴日期" )
	private Date pensionStart;
	/**
	 * 医疗起缴日期
	 */
	@ExcelAttribute(name = "医疗起缴日期", isDate = true)
	@Schema(description = "医疗起缴日期" )
	@ExcelProperty("医疗起缴日期" )
	private Date medicalStart;
	/**
	 * 失业起缴日期
	 */
	@ExcelAttribute(name = "失业起缴日期", isDate = true)
	@Schema(description = "失业起缴日期" )
	@ExcelProperty("失业起缴日期" )
	private Date unemployStart;
	/**
	 * 工伤起缴日期
	 */
	@ExcelAttribute(name = "工伤起缴日期", isDate = true)
	@Schema(description = "工伤起缴日期" )
	@ExcelProperty("工伤起缴日期" )
	private Date workInjuryStart;
	/**
	 * 生育起缴日期
	 */
	@ExcelAttribute(name = "生育起缴日期", isDate = true)
	@Schema(description = "生育起缴日期" )
	@ExcelProperty("生育起缴日期" )
	private Date birthStart;
	/**
	 * 大病起缴日期
	 */
	@ExcelAttribute(name = "大病起缴日期", isDate = true)
	@Schema(description = "大病起缴日期" )
	@ExcelProperty("大病起缴日期" )
	private Date bigailmentStart;
	/**
	 * 养老办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "养老办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "养老办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "养老办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("养老办理状态：0待办理1办理成功2办理失败3已派减" )
	private String pensionHandle;
	/**
	 * 医疗办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "医疗办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "医疗办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "医疗办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("医疗办理状态：0待办理1办理成功2办理失败3已派减" )
	private String medicalHandle;
	/**
	 * 失业办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "失业办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "失业办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "失业办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("失业办理状态：0待办理1办理成功2办理失败3已派减" )
	private String unemployHandle;
	/**
	 * 工伤办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "工伤办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "工伤办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "工伤办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("工伤办理状态：0待办理1办理成功2办理失败3已派减" )
	private String workInjuryHandle;
	/**
	 * 生育办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "生育办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "生育办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "生育办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("生育办理状态：0待办理1办理成功2办理失败3已派减" )
	private String birthHandle;
	/**
	 * 大病办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@Length(max = 1, message = "大病办理状态：0待办理1办理成功2办理失败3已派减 不能超过1 个字符" )
	@ExcelAttribute(name = "大病办理状态：0待办理1办理成功2办理失败3已派减", maxLength = 1)
	@Schema(description = "大病办理状态：0待办理1办理成功2办理失败3已派减" )
	@ExcelProperty("大病办理状态：0待办理1办理成功2办理失败3已派减" )
	private String bigailmentHandle;

}
