/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAgentConfig;
import com.yifu.cloud.plus.v1.yifu.social.service.TAgentConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 预估临时政策配置表
 *
 * @author fxj
 * @date 2022-07-12 08:53:19
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tagentconfig" )
@Tag(name = "预估临时政策配置表管理")
public class TAgentConfigController {

    private final TAgentConfigService tAgentConfigService;
    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tAgentConfig 预估临时政策配置表
     * @return
     */
	@Operation(summary = "简单分页查询", description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TAgentConfig>> getTAgentConfigPage(Page<TAgentConfig> page, TAgentConfig tAgentConfig) {
        return new R<>(tAgentConfigService.getTAgentConfigPage(page,tAgentConfig));
    }
    /**
     * 不分页查询
     * @param tAgentConfig 预估临时政策配置表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<TAgentConfig>> getTAgentConfigNoPage(@RequestBody TAgentConfig tAgentConfig) {
        return R.ok(tAgentConfigService.list(Wrappers.query(tAgentConfig)));
    }

    /**
     * 通过id查询预估临时政策配置表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    public R<TAgentConfig> getById(@PathVariable("id" ) String id) {
        return R.ok(tAgentConfigService.getById(id));
    }

    /**
     * 新增预估临时政策配置表
     * @param tAgentConfig 预估临时政策配置表
     * @return R
     */
    @Operation(summary = "新增预估临时政策配置表", description = "新增预估临时政策配置表：hasPermission('social_tagentconfig_add')")
    @SysLog("新增预估临时政策配置表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('social_tagentconfig_add')" )
    public R<Boolean> save(@RequestBody TAgentConfig tAgentConfig) {
        return R.ok(tAgentConfigService.save(tAgentConfig));
    }

    /**
     * 修改预估临时政策配置表
     * @param tAgentConfig 预估临时政策配置表
     * @return R
     */
    @Operation(summary = "修改预估临时政策配置表", description = "修改预估临时政策配置表：hasPermission('social_tagentconfig_edit')")
    @SysLog("修改预估临时政策配置表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('social_tagentconfig_edit')" )
    public R<Boolean> updateById(@RequestBody TAgentConfig tAgentConfig) {
        return R.ok(tAgentConfigService.updateById(tAgentConfig));
    }

    /**
     * 通过id删除预估临时政策配置表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除预估临时政策配置表", description = "通过id删除预估临时政策配置表：hasPermission('social_tagentconfig_del')")
    @SysLog("通过id删除预估临时政策配置表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('social_tagentconfig_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tAgentConfigService.removeById(id));
    }

	/**
	 *  修改开启关闭状态
	 * @param id
	 * @return R
	 */
	@Operation(summary = "通过id删除预估临时政策配置表", description = "通过id删除预估临时政策配置表：hasPermission('social_tagentconfig_del')")
	@PostMapping("/updateOpenFlagById")
	@PreAuthorize("@pms.hasPermission('social_tagentconfig_edit')")
	public R updateOpenFlagById(@RequestParam String id) {
		return tAgentConfigService.updateFlagById(id);
	}
}
