/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPaymentInfo;
import com.yifu.cloud.plus.v1.yifu.social.service.TPaymentInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 缴费库
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tpaymentinfo" )
@Tag(name = "缴费库管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TPaymentInfoController {

    private final  TPaymentInfoService tPaymentInfoService;
    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tPaymentInfo 缴费库
     * @return
     */
	@Operation(summary = "简单分页查询", description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TPaymentInfo>> getTPaymentInfoPage(Page<TPaymentInfo> page, TPaymentInfo tPaymentInfo) {
        return  new R<>(tPaymentInfoService.getTPaymentInfoPage(page,tPaymentInfo));
    }
    /**
     * 不分页查询
     * @param tPaymentInfo 缴费库
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<TPaymentInfo>> getTPaymentInfoNoPage(@RequestBody TPaymentInfo tPaymentInfo) {
        return R.ok(tPaymentInfoService.list(Wrappers.query(tPaymentInfo)));
    }

    /**
     * 通过id查询缴费库
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('social_tpaymentinfo_get')")
    @GetMapping("/{id}" )
    public R<TPaymentInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(tPaymentInfoService.getById(id));
    }

    /**
     * 新增缴费库
     * @param tPaymentInfo 缴费库
     * @return R
     */
    @Operation(summary = "新增缴费库", description = "新增缴费库：hasPermission('social_tpaymentinfo_add')")
    @SysLog("新增缴费库" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('social_tpaymentinfo_add')" )
    public R<Boolean> save(@RequestBody TPaymentInfo tPaymentInfo) {
        return R.ok(tPaymentInfoService.save(tPaymentInfo));
    }

    /**
     * 修改缴费库
     * @param tPaymentInfo 缴费库
     * @return R
     */
    @Operation(summary = "修改缴费库", description = "修改缴费库：hasPermission('social_tpaymentinfo_edit')")
    @SysLog("修改缴费库" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('social_tpaymentinfo_edit')" )
    public R<Boolean> updateById(@RequestBody TPaymentInfo tPaymentInfo) {
        return R.ok(tPaymentInfoService.updateById(tPaymentInfo));
    }

    /**
     * 通过id删除缴费库
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除缴费库", description = "通过id删除缴费库：hasPermission('social_tpaymentinfo_del')")
    @SysLog("通过id删除缴费库" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('social_tpaymentinfo_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tPaymentInfoService.removeById(id));
    }

}
