/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.TProvidentFund;
import com.yifu.cloud.plus.v1.yifu.social.service.TProvidentFundService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TProvidentFundSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 公积金信息
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tprovidentfund" )
@Tag(name = "公积金信息管理")
public class TProvidentFundController {

    private final TProvidentFundService tProvidentFundService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tProvidentFund 公积金信息
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TProvidentFund>> getTProvidentFundPage(Page<TProvidentFund> page, TProvidentFundSearchVo tProvidentFund) {
        return  new R<>(tProvidentFundService.getTProvidentFundPage(page,tProvidentFund));
    }
    /**
     * 不分页查询
     * @param tProvidentFund 公积金信息
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tprovidentfund_get')" )
    public R<List<TProvidentFund>> getTProvidentFundNoPage(@RequestBody TProvidentFundSearchVo tProvidentFund) {
        return R.ok(tProvidentFundService.noPageDiy(tProvidentFund));
    }

    /**
     * 通过id查询公积金信息
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tprovidentfund_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tprovidentfund_get')" )
    public R<TProvidentFund> getById(@PathVariable("id" ) String id) {
        return R.ok(tProvidentFundService.getById(id));
    }

    /**
     * 新增公积金信息
     * @param tProvidentFund 公积金信息
     * @return R
     */
    @Operation(summary = "新增公积金信息", description = "新增公积金信息：hasPermission('demo_tprovidentfund_add')")
    @SysLog("新增公积金信息" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tprovidentfund_add')" )
    public R<Boolean> save(@RequestBody TProvidentFund tProvidentFund) {
        return R.ok(tProvidentFundService.save(tProvidentFund));
    }

    /**
     * 修改公积金信息
     * @param tProvidentFund 公积金信息
     * @return R
     */
    @Operation(summary = "修改公积金信息", description = "修改公积金信息：hasPermission('demo_tprovidentfund_edit')")
    @SysLog("修改公积金信息" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tprovidentfund_edit')" )
    public R<Boolean> updateById(@RequestBody TProvidentFund tProvidentFund) {
        return R.ok(tProvidentFundService.updateById(tProvidentFund));
    }

    /**
     * 通过id删除公积金信息
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除公积金信息", description = "通过id删除公积金信息：hasPermission('demo_tprovidentfund_del')")
    @SysLog("通过id删除公积金信息" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tprovidentfund_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tProvidentFundService.removeById(id));
    }

    /**
	 * 公积金信息 批量导入
	 *
     * @author fxj
     * @date 2022-07-15 11:38:05
	 **/
    @SneakyThrows
    @Operation(description = "批量新增公积金信息 hasPermission('demo_tprovidentfund-batch-import')")
    @SysLog("批量新增公积金信息")
    @PostMapping("/importListAdd")
    @PreAuthorize("@pms.hasPermission('demo_tprovidentfund-batch-import')")
    public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file){
        return tProvidentFundService.importDiy(file.getInputStream());
    }

    /**
     * 公积金信息 批量导出
     * @author fxj
     * @date 2022-07-15 11:38:05
     **/
    @Operation(description = "导出公积金信息 hasPermission('demo_tprovidentfund-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('demo_tprovidentfund-export')")
    public void export(HttpServletResponse response, @RequestBody TProvidentFundSearchVo searchVo) {
            tProvidentFundService.listExport(response,searchVo);
    }
}
