/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundHistory;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialFundHistoryService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TSocialFundHistorySearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 社保公积金调基历史记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsocialfundhistory" )
@Tag(name = "社保公积金调基历史记录表管理")
public class TSocialFundHistoryController {

    private final TSocialFundHistoryService tSocialFundHistoryService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tSocialFundHistory 社保公积金调基历史记录表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TSocialFundHistory>> getTSocialFundHistoryPage(Page<TSocialFundHistory> page, TSocialFundHistorySearchVo tSocialFundHistory) {
        return  new R<>(tSocialFundHistoryService.getTSocialFundHistoryPage(page,tSocialFundHistory));
    }
    /**
     * 不分页查询
     * @param tSocialFundHistory 社保公积金调基历史记录表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tsocialfundhistory_get')" )
    public R<List<TSocialFundHistory>> getTSocialFundHistoryNoPage(@RequestBody TSocialFundHistorySearchVo tSocialFundHistory) {
        return R.ok(tSocialFundHistoryService.noPageDiy(tSocialFundHistory));
    }

    /**
     * 通过id查询社保公积金调基历史记录表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tsocialfundhistory_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tsocialfundhistory_get')" )
    public R<TSocialFundHistory> getById(@PathVariable("id" ) String id) {
        return R.ok(tSocialFundHistoryService.getById(id));
    }

    /**
     * 新增社保公积金调基历史记录表
     * @param tSocialFundHistory 社保公积金调基历史记录表
     * @return R
     */
    @Operation(summary = "新增社保公积金调基历史记录表", description = "新增社保公积金调基历史记录表：hasPermission('demo_tsocialfundhistory_add')")
    @SysLog("新增社保公积金调基历史记录表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tsocialfundhistory_add')" )
    public R<Boolean> save(@RequestBody TSocialFundHistory tSocialFundHistory) {
        return R.ok(tSocialFundHistoryService.save(tSocialFundHistory));
    }

    /**
     * 修改社保公积金调基历史记录表
     * @param tSocialFundHistory 社保公积金调基历史记录表
     * @return R
     */
    @Operation(summary = "修改社保公积金调基历史记录表", description = "修改社保公积金调基历史记录表：hasPermission('demo_tsocialfundhistory_edit')")
    @SysLog("修改社保公积金调基历史记录表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tsocialfundhistory_edit')" )
    public R<Boolean> updateById(@RequestBody TSocialFundHistory tSocialFundHistory) {
        return R.ok(tSocialFundHistoryService.updateById(tSocialFundHistory));
    }

    /**
     * 通过id删除社保公积金调基历史记录表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除社保公积金调基历史记录表", description = "通过id删除社保公积金调基历史记录表：hasPermission('demo_tsocialfundhistory_del')")
    @SysLog("通过id删除社保公积金调基历史记录表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tsocialfundhistory_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tSocialFundHistoryService.removeById(id));
    }

    /**
	 * 社保公积金调基历史记录表 批量导入
	 *
     * @author fxj
     * @date 2022-07-15 11:38:05
	 **/
    @SneakyThrows
    @Operation(description = "批量新增社保公积金调基历史记录表 hasPermission('demo_tsocialfundhistory-batch-import')")
    @SysLog("批量新增社保公积金调基历史记录表")
    @PostMapping("/importListAdd")
    @PreAuthorize("@pms.hasPermission('demo_tsocialfundhistory-batch-import')")
    public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file){
        return tSocialFundHistoryService.importDiy(file.getInputStream());
    }

    /**
     * 社保公积金调基历史记录表 批量导出
     * @author fxj
     * @date 2022-07-15 11:38:05
     **/
    @Operation(description = "导出社保公积金调基历史记录表 hasPermission('demo_tsocialfundhistory-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('demo_tsocialfundhistory-export')")
    public void export(HttpServletResponse response, @RequestBody TSocialFundHistorySearchVo searchVo) {
            tSocialFundHistoryService.listExport(response,searchVo);
    }
}
