/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysBaseSetInfo;

import java.util.Map;

/**
 * 基数设置表
 *
 * @author hgw
 * @date 2022-07-11 18:21:23
 */
public interface SysBaseSetInfoService extends IService<SysBaseSetInfo> {
	/**
	 * 基数设置表简单分页查询
	 *
	 * @param sysBaseSetInfo 基数设置表
	 * @return
	 */
	IPage<SysBaseSetInfo> getSysBaseSetInfoPage(Page<SysBaseSetInfo> page, SysBaseSetInfo sysBaseSetInfo);

	/**
	 * @param sysBaseSetInfo
	 * @Description: 新增
	 * @Author: hgw
	 * @Date: 2022/7/12 10:00
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> saveSysBase(SysBaseSetInfo sysBaseSetInfo);

	/**
	 * @param sysBaseSetInfo
	 * @Description: 修改
	 * @Author: hgw
	 * @Date: 2022/7/12 10:00
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> updateSysBase(SysBaseSetInfo sysBaseSetInfo);

	/**
	 * @param
	 * @Description: 获取社保基数配置的Map
	 * @Author: hgw
	 * @Date: 2020/10/27 16:44
	 * @return: java.util.Map<java.lang.String, com.yifu.cloud.v1.hrms.api.entity.SysBaseSetInfo>
	 **/
	Map<String, SysBaseSetInfo> getSysBaseSetInfoMap(String baseType);

}
