/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAgentConfig;

/**
 * 预估临时政策配置表
 *
 * @author fxj
 * @date 2022-07-12 08:53:19
 */
public interface TAgentConfigService extends IService<TAgentConfig> {
    /**
     * 预估临时政策配置表简单分页查询
     * @param tAgentConfig 预估临时政策配置表
     * @return
     */
    IPage<TAgentConfig> getTAgentConfigPage(Page<TAgentConfig> page, TAgentConfig tAgentConfig);

	/**
	 * 修改开启关闭状态
	 * @param id 预估临时政策配置表id
	 * @return
	 */
	R updateFlagById(String id);
}
