/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.DispatchDetailVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TDispatchInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
public interface TDispatchInfoService extends IService<TDispatchInfo> {
    /**
     * 派单信息记录表简单分页查询
     * @param tDispatchInfo 派单信息记录表
     * @return
     */
    IPage<TDispatchInfo> getTDispatchInfoPage(Page<TDispatchInfo> page, TDispatchInfo tDispatchInfo);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TDispatchInfoSearchVo searchVo);

    List<TDispatchInfo> noPageDiy(TDispatchInfoSearchVo searchVo);

    R<List<ErrorMessage>> importReduceDiy(InputStream inputStream);

	R<Boolean> removeByIdDiy(String id);

	DispatchDetailVo getSocialAndFundInfoById(String id);

    List<ErrorMessage> addBatchApplyAudit(List<String> initStrToList, YifuUser user, Integer flag, String auditStatus, String auditRemark);
}
