/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAgentConfig;
import com.yifu.cloud.plus.v1.yifu.social.entity.TForecastLibrary;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;

/**
 * 预估费用
 *
 * @author hgw
 * @date 2022-07-18 16:21:40
 */
public interface TForecastLibraryService extends IService<TForecastLibrary> {
	/**
	 * 预估费用简单分页查询
	 *
	 * @param tForecastLibrary 预估费用
	 * @return
	 */
	IPage<TForecastLibrary> getTForecastLibraryPage(Page<TForecastLibrary> page, TForecastLibrary tForecastLibrary);

	void listExport(HttpServletResponse response, TForecastLibrary searchVo);

	List<TForecastLibrary> noPageDiy(TForecastLibrary searchVo);

	/**
	 * @param payMonths 缴纳月
	 * @param empIdCard 身份证
	 * @param settleDomainIds 项目id
	 * @Description: 按缴纳月重新生成
	 * @Author: hgw
	 * @Date: 2022/7/18 17:11
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.Boolean>
	 **/
	R<String> createForecastlibary(String payMonths, String empIdCard, String settleDomainIds);

	/**
	 * @param socialFundInfo
	 * @Description: 批量调基，同步预估库
	 * @Author: hgw
	 * @Date: 2022/7/25 17:33
	 * @return: void
	 **/
	R<String> updateToneForecastLibary(TSocialFundInfo socialFundInfo);

}
