/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAgentConfig;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TAgentConfigMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TAgentConfigService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * 预估临时政策配置表
 *
 * @author fxj
 * @date 2022-07-12 08:53:19
 */
@Service
@RequiredArgsConstructor
public class TAgentConfigServiceImpl extends ServiceImpl<TAgentConfigMapper, TAgentConfig> implements TAgentConfigService {

    /**
     * 预估临时政策配置表简单分页查询
     * @param tAgentConfig 预估临时政策配置表
     * @return
     */
    @Override
    public IPage<TAgentConfig> getTAgentConfigPage(Page<TAgentConfig> page, TAgentConfig tAgentConfig){
        return baseMapper.getTAgentConfigPage(page,tAgentConfig);
    }

	@Override
	public R updateFlagById(String id) {
		if (!Common.isNotNull(id)){
			return R.failed("id不可为空！");
		}
		TAgentConfig tAgentConfig = this.getById(id);
		if (null == tAgentConfig){
			return R.failed("找不到对应ID的配置数据");
		}
		// 启用改禁用 或 禁用改启用
		if (null != tAgentConfig.getOpenFlag() && tAgentConfig.getOpenFlag().intValue() == CommonConstants.ZERO_INT){
			tAgentConfig.setOpenFlag(CommonConstants.ONE_INT);
		}else if (null != tAgentConfig.getOpenFlag() && tAgentConfig.getOpenFlag().intValue() == CommonConstants.ONE_INT){
			tAgentConfig.setOpenFlag(CommonConstants.ZERO_INT);
		}
		if (this.updateById(tAgentConfig)){
			return R.ok();
		}else {
			return R.failed("更新失败！");
		}
	}
}
