/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchDayConf;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TDispatchDayConfMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TDispatchDayConfService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TDispatchDayConfSearchVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TDispatchDayConfVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
/**
 * 各个地市派单日期
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Log4j2
@Service
public class TDispatchDayConfServiceImpl extends ServiceImpl<TDispatchDayConfMapper, TDispatchDayConf> implements TDispatchDayConfService {
    /**
     * 各个地市派单日期简单分页查询
     * @param tDispatchDayConf 各个地市派单日期
     * @return
     */
    @Override
    public IPage<TDispatchDayConf> getTDispatchDayConfPage(Page<TDispatchDayConf> page, TDispatchDayConf tDispatchDayConf){
        return baseMapper.getTDispatchDayConfPage(page,tDispatchDayConf);
    }

    /**
     * 各个地市派单日期批量导出
     * @return
     */
    @Override
    public void listExport(HttpServletResponse response, TDispatchDayConfSearchVo searchVo){
        String fileName = "不良记录批量导出" + DateUtil.getThisTime() + ".xlsx";
        //获取要导出的列表
        List<TDispatchDayConf> list = new ArrayList<>();
        long count = noPageCountDiy(searchVo);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            response.setContentType("multipart/form-data");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName  , "UTF-8"));
            // 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
            //EasyExcel.write(out, TEmpBadRecord.class).sheet("不良记录").doWrite(list);
            ExcelWriter  excelWriter = EasyExcel.write(out, TDispatchDayConf.class).build();
            int index = 0;
            if (count >  CommonConstants.ZERO_INT){
                for (int i = 0; i <= count; ) {
                    // 获取实际记录
                    searchVo.setLimitStart(i);
                    searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
                    list = noPageDiy(searchVo);
                    if (Common.isNotNull(list)){
                        ExcelUtil<TDispatchDayConf> util = new ExcelUtil<>(TDispatchDayConf.class);
                        for (TDispatchDayConf vo:list){
                            util.convertEntity(vo,null,null,null);
                        }
                    }
                    if (Common.isNotNull(list)){
                        WriteSheet writeSheet = EasyExcel.writerSheet("各个地市派单日期"+index).build();
                        excelWriter.write(list,writeSheet);
                        index++;
                    }
                    i = i + CommonConstants.EXCEL_EXPORT_LIMIT;
                    if (Common.isNotNull(list)){
                        list.clear();
                    }
                }
            }else {
                WriteSheet writeSheet = EasyExcel.writerSheet("各个地市派单日期"+index).build();
                excelWriter.write(list,writeSheet);
            }
            if (Common.isNotNull(list)){
                list.clear();
            }
            out.flush();
            excelWriter.finish();
        }catch (Exception e){
            log.error("执行异常" ,e);
        }finally {
            try {
                if (null != out) {
                    out.close();
                }
            } catch (IOException e) {
                log.error("执行异常", e);
            }
        }
    }

    @Override
    public List<TDispatchDayConf> noPageDiy(TDispatchDayConfSearchVo searchVo) {
        LambdaQueryWrapper<TDispatchDayConf> wrapper = buildQueryWrapper(searchVo);
        List<String> idList = Common.getList(searchVo.getIds());
        if (Common.isNotNull(idList)){
            wrapper.in(TDispatchDayConf::getId,idList);
        }
        if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0){
            wrapper.last(" limit "+ searchVo.getLimitStart() +","+ searchVo.getLimitEnd());
        }
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        return baseMapper.selectList(wrapper);
    }

    private  Long noPageCountDiy(TDispatchDayConfSearchVo searchVo) {
        LambdaQueryWrapper<TDispatchDayConf> wrapper = buildQueryWrapper(searchVo);
        List<String> idList = Common.getList(searchVo.getIds());
        if (Common.isNotNull(idList)){
            wrapper.in(TDispatchDayConf::getId,idList);
        }
        return baseMapper.selectCount(wrapper);
    }

    private LambdaQueryWrapper buildQueryWrapper(TDispatchDayConfSearchVo entity){
        LambdaQueryWrapper<TDispatchDayConf> wrapper = Wrappers.lambdaQuery();
        if (ArrayUtil.isNotEmpty(entity.getCreateTimes())) {
            wrapper.ge(TDispatchDayConf::getCreateTime, entity.getCreateTimes()[0])
                    .le(TDispatchDayConf::getCreateTime,
                            entity.getCreateTimes()[1]);
        }
        if (Common.isNotNull(entity.getCreateName())){
            wrapper.eq(TDispatchDayConf::getCreateName,entity.getCreateName());
        }
        return wrapper;
    }

    @Override
    public R<List<ErrorMessage>> importDiy(InputStream inputStream) {
        List<ErrorMessage> errorMessageList = new ArrayList<>();
        ExcelUtil<TDispatchDayConfVo> util1 = new ExcelUtil<>(TDispatchDayConfVo.class);;
        // 写法2：
        // 匿名内部类 不用额外写一个DemoDataListener
        // 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
        try {
            EasyExcel.read(inputStream, TDispatchDayConfVo.class, new ReadListener<TDispatchDayConfVo>() {
                /**
                 * 单次缓存的数据量
                 */
                public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
                /**
                 *临时存储
                 */
                private List<TDispatchDayConfVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

                @Override
                public void invoke(TDispatchDayConfVo data, AnalysisContext context) {
                    ReadRowHolder readRowHolder = context.readRowHolder();
                    Integer rowIndex = readRowHolder.getRowIndex();
                    data.setRowIndex(rowIndex+1);
                    ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
                    if (Common.isNotNull(errorMessage)){
                        errorMessageList.add(errorMessage);
                    }else {
                        cachedDataList.add(data);
                    }
                    if (cachedDataList.size() >= BATCH_COUNT) {
                        saveData();
                        // 存储完成清理 list
                        cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
                    }
                }
                @Override
                public void doAfterAllAnalysed(AnalysisContext context) {
                    saveData();
                }

                /**
                 * 加上存储数据库
                 */
                private void saveData() {
                    log.info("{}条数据，开始存储数据库！", cachedDataList.size());
                    importTDispatchDayConf(cachedDataList,errorMessageList);
                    log.info("存储数据库成功！");
                }
            }).sheet().doRead();
        }catch (Exception e){
            log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR,e);
            return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
        }
        return  R.ok(errorMessageList);
    }
    private void importTDispatchDayConf(List<TDispatchDayConfVo> excelVOList, List<ErrorMessage> errorMessageList) {
        // 个性化校验逻辑
        ErrorMessage errorMsg;
        // 执行数据插入操作 组装
        for (int i = 0; i < excelVOList.size(); i++) {
            TDispatchDayConfVo excel = excelVOList.get(i);
            // 数据合法情况 TODO

            // 插入
            insertExcel(excel);
            errorMessageList.add(new ErrorMessage(excel.getRowIndex(),CommonConstants.SAVE_SUCCESS));
        }
    }
    /**
     * 插入excel bad record
     */
    private void insertExcel(TDispatchDayConfVo excel) {
        TDispatchDayConf insert = new TDispatchDayConf();
        BeanUtil.copyProperties(excel, insert);
        this.save(insert);
    }
}
